## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
oldpar <- par(no.readonly = TRUE)
oldoptions <- options()

## ----setup--------------------------------------------------------------------
library(BCDAG)

## -----------------------------------------------------------------------------
set.seed(1)
q <- 10
w <- 0.2
DAG <- rDAG(q,w)

## ----printDAG-----------------------------------------------------------------
DAG

## -----------------------------------------------------------------------------
a <- q
U <- diag(1,q)
outDL <- rDAGWishart(n=1, DAG, a, U)
class(outDL)

## -----------------------------------------------------------------------------
L <- outDL$L; D <- outDL$D
class(L); class(D)

## -----------------------------------------------------------------------------
# Precision matrix
Omega <- L %*% solve(D) %*% t(L)
# Covariance matrix
Sigma <- solve(Omega)

## -----------------------------------------------------------------------------
n <- 1000
X <- mvtnorm::rmvnorm(n = n, sigma = Sigma)

## ---- include = FALSE---------------------------------------------------------
par(oldpar)
options(oldoptions)

