/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.io.NexusImporter;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.stats.DiscreteStatistics;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;

public class TreeShape {
    public static double getNBarStatistic(Tree tree) {
        double d = 0.0;
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            while (!tree.isRoot(nodeRef)) {
                nodeRef = tree.getParent(nodeRef);
                d += 1.0;
            }
        }
        return d / (double)tree.getExternalNodeCount();
    }

    public static double getVarNBarStatistic(Tree tree) {
        double[] dArray = new double[tree.getExternalNodeCount()];
        for (int i = 0; i < dArray.length; ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            while (!tree.isRoot(nodeRef)) {
                nodeRef = tree.getParent(nodeRef);
                int n = i;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        return DiscreteStatistics.variance(dArray);
    }

    public static double getCStatistic(Tree tree) {
        double d = 0.0;
        int n = tree.getExternalNodeCount();
        for (int i = 0; i < n - 1; ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            int n2 = TreeUtils.getLeafCount(tree, tree.getChild(nodeRef, 0));
            int n3 = TreeUtils.getLeafCount(tree, tree.getChild(nodeRef, 1));
            d += (double)Math.abs(n2 - n3);
        }
        return d *= 2.0 / (double)(n * (n - 3) + 2);
    }

    public static double getB1Statistic(Tree tree) {
        double d = 0.0;
        int n = tree.getInternalNodeCount();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            if (tree.isRoot(nodeRef)) continue;
            d += 1.0 / (double)TreeShape.getMi(tree, nodeRef);
        }
        return d;
    }

    private static int getMi(Tree tree, NodeRef nodeRef) {
        int n = tree.getChildCount(nodeRef);
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = TreeShape.getMi(tree, tree.getChild(nodeRef, i));
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return ++n2;
    }

    public static double getTreeness(Tree tree) {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            nodeRef2 = tree.getExternalNode(n);
            nodeRef = tree.getParent(nodeRef2);
            d += tree.getNodeHeight(nodeRef) - tree.getNodeHeight(nodeRef2);
        }
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            nodeRef2 = tree.getInternalNode(n);
            if (tree.isRoot(nodeRef2)) continue;
            nodeRef = tree.getParent(nodeRef2);
            d2 += tree.getNodeHeight(nodeRef) - tree.getNodeHeight(nodeRef2);
        }
        return d2 / d;
    }

    public static double getGammaStatistic(Tree tree) {
        int n = tree.getExternalNodeCount();
        double[] dArray = TreeShape.getIntervals(tree);
        double d = 0.0;
        for (int i = 2; i <= n; ++i) {
            d += (double)i * dArray[i - 2];
        }
        double d2 = 0.0;
        for (int i = 2; i < n; ++i) {
            for (int j = 2; j <= i; ++j) {
                d2 += (double)j * dArray[j - 2];
            }
        }
        d2 *= 1.0 / (double)n - 2.0;
        d2 -= d / 2.0;
        return d2 /= d * Math.sqrt(1.0 / (12.0 * ((double)n - 2.0)));
    }

    private static double[] getIntervals(Tree tree) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (TreeUtils.isUltrametric(tree)) {
            for (int i = 0; i < tree.getInternalNodeCount(); ++i) {
                arrayList.add(tree.getNodeHeight(tree.getInternalNode(i)));
            }
            Collections.sort(arrayList);
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length - 1; ++i) {
                double d = (Double)arrayList.get(i);
                double d2 = (Double)arrayList.get(i + 1);
                dArray[i] = d - d2;
            }
            dArray[dArray.length - 1] = (Double)arrayList.get(dArray.length - 1);
            return dArray;
        }
        throw new IllegalArgumentException("Expecting ultrametric tree.");
    }

    public static void main(String[] stringArray) throws Exception {
        NexusImporter nexusImporter = new NexusImporter(new FileReader(stringArray[0]));
        Tree[] treeArray = nexusImporter.importTrees(null);
        System.out.println("File = " + stringArray[0]);
        double[] dArray = new double[treeArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = TreeShape.getTreeness(treeArray[i]);
        }
        System.out.println("Mean treeness = " + DiscreteStatistics.mean(dArray));
        System.out.println("Lower (95%) treeness = " + DiscreteStatistics.quantile(0.025, dArray));
        System.out.println("Upper (95%) treeness = " + DiscreteStatistics.quantile(0.975, dArray));
    }
}

