/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.nucleotide;

import dr.evolution.datatype.Nucleotides;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class GTR
extends BaseSubstitutionModel
implements Citable {
    public static final String A_TO_C = "AC";
    public static final String A_TO_G = "AG";
    public static final String A_TO_T = "AT";
    public static final String C_TO_G = "CG";
    public static final String C_TO_T = "CT";
    public static final String G_TO_T = "GT";
    private Parameter ratesParameter = null;
    private Variable<Double> rateACVariable = null;
    private Variable<Double> rateAGVariable = null;
    private Variable<Double> rateATVariable = null;
    private Variable<Double> rateCGVariable = null;
    private Variable<Double> rateCTVariable = null;
    private Variable<Double> rateGTVariable = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("S", "Tavar\u00e9")}, "Some probabilistic and statistical problems in the analysis of DNA sequences", 1985, "In: Miura R. M., editor. Lectures on Mathematics in the Life Sciences", 17, 57, 86);

    public GTR(Parameter parameter, FrequencyModel frequencyModel) {
        super("GTR", Nucleotides.INSTANCE, frequencyModel);
        this.ratesParameter = parameter;
        this.ratesParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.addVariable(parameter);
    }

    public GTR(Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, Variable<Double> variable5, Variable<Double> variable6, FrequencyModel frequencyModel) {
        super("GTR", Nucleotides.INSTANCE, frequencyModel);
        if (variable != null) {
            this.addVariable(variable);
            variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateACVariable = variable;
        }
        if (variable2 != null) {
            this.addVariable(variable2);
            variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateAGVariable = variable2;
        }
        if (variable3 != null) {
            this.addVariable(variable3);
            variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateATVariable = variable3;
        }
        if (variable4 != null) {
            this.addVariable(variable4);
            variable4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateCGVariable = variable4;
        }
        if (variable5 != null) {
            this.addVariable(variable5);
            variable5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateCTVariable = variable5;
        }
        if (variable6 != null) {
            this.addVariable(variable6);
            variable6.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateGTVariable = variable6;
        }
    }

    public void setAbsoluteRates(double[] dArray, int n) {
        for (int i = 0; i < this.relativeRates.length; ++i) {
            this.relativeRates[i] = dArray[i] / dArray[n];
        }
        this.updateMatrix = true;
        this.fireModelChanged();
    }

    public void setRelativeRates(double[] dArray) {
        System.arraycopy(dArray, 0, this.relativeRates, 0, this.relativeRates.length);
        this.updateMatrix = true;
        this.fireModelChanged();
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        if (this.ratesParameter == null) {
            if (this.rateACVariable != null) {
                dArray[0] = this.rateACVariable.getValue(0);
            }
            if (this.rateAGVariable != null) {
                dArray[1] = this.rateAGVariable.getValue(0);
            }
            if (this.rateATVariable != null) {
                dArray[2] = this.rateATVariable.getValue(0);
            }
            if (this.rateCGVariable != null) {
                dArray[3] = this.rateCGVariable.getValue(0);
            }
            if (this.rateCTVariable != null) {
                dArray[4] = this.rateCTVariable.getValue(0);
            }
            if (this.rateGTVariable != null) {
                dArray[5] = this.rateGTVariable.getValue(0);
            }
        } else {
            System.arraycopy(this.ratesParameter.getParameterValues(), 0, dArray, 0, dArray.length);
        }
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>GTR Model</em> Instantaneous Rate Matrix = <table><tr><td></td><td>A</td><td>C</td><td>G</td><td>T</td></tr>");
        stringBuffer.append("<tr><td>A</td><td></td><td>");
        stringBuffer.append(this.relativeRates[0]);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.relativeRates[1]);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.relativeRates[2]);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>C</td><td></td><td></td><td>");
        stringBuffer.append(this.relativeRates[3]);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.relativeRates[4]);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>G</td><td></td><td></td><td></td><td>");
        stringBuffer.append(this.relativeRates[5]);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>G</td><td></td><td></td><td></td><td></td></tr></table>");
        return stringBuffer.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "GTR nucleotide substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

