/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.DiffusionProcessDelegate;
import dr.evomodel.treedatalikelihood.continuous.MultivariateTraitDebugUtilities;
import dr.evomodel.treedatalikelihood.continuous.RepeatedMeasuresTraitDataModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.AbstractVarianceProportionStatistic;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.inference.model.VarianceProportionStatistic;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class VarianceProportionStatisticPopulation
extends AbstractVarianceProportionStatistic
implements VariableListener,
ModelListener {
    private final MultivariateDiffusionModel diffusionModel;
    private VarianceProportionStatistic.TreeVarianceSums treeSums;
    private DenseMatrix64F diffusionVariance;
    private DenseMatrix64F samplingVariance;
    private boolean treeKnown = false;
    private boolean varianceKnown = false;
    private final DiffusionProcessDelegate diffusionProcessDelegate;
    private final ContinuousDataLikelihoodDelegate likelihoodDelegate;
    private double[] treeDepths;

    public VarianceProportionStatisticPopulation(Tree tree, TreeDataLikelihood treeDataLikelihood, RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel, MultivariateDiffusionModel multivariateDiffusionModel, AbstractVarianceProportionStatistic.MatrixRatios matrixRatios) {
        super(tree, treeDataLikelihood, repeatedMeasuresTraitDataModel, matrixRatios);
        this.likelihoodDelegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
        this.diffusionModel = multivariateDiffusionModel;
        this.diffusionProcessDelegate = this.likelihoodDelegate.getDiffusionProcessDelegate();
        this.treeDepths = new double[tree.getExternalNodeCount()];
        this.diffusionVariance = null;
        this.samplingVariance = null;
        if (this.isTreeRandom.booleanValue()) {
            ((AbstractModel)((Object)tree)).addModelListener(this);
        }
        this.diffusionModel.getPrecisionParameter().addParameterListener(this);
        this.dataModel.getExtensionPrecision().addParameterListener(this);
        this.diffusionProcessDelegate.addModelListener(this);
    }

    @Override
    protected void updateVarianceComponents() {
        this.diffusionProcessDelegate.getMeanTipVariances(this.likelihoodDelegate.getRootProcessDelegate().getPseudoObservations(), this.treeDepths, this.diffusionVariance, this.diffusionComponent);
        this.dataModel.getMeanTipVariances(this.samplingVariance, this.samplingComponent);
    }

    @Override
    protected boolean needToUpdate(int n) {
        boolean bl = false;
        if (!this.treeKnown) {
            this.updateTreeDepths();
            this.treeKnown = true;
            bl = true;
        }
        if (!this.varianceKnown) {
            this.samplingVariance = MissingOps.wrap(this.dataModel.getSamplingVariance().toArrayComponents(), 0, this.dimTrait, this.dimTrait);
            this.diffusionVariance = MissingOps.wrap(this.diffusionModel.getPrecisionmatrixAsVector(), 0, this.dimTrait, this.dimTrait);
            CommonOps.invert(this.diffusionVariance);
            this.varianceKnown = true;
            bl = true;
        }
        return bl;
    }

    private void updateTreeDepths() {
        double d = this.likelihoodDelegate.getRateTransformationNormalization();
        this.treeDepths = MultivariateTraitDebugUtilities.getTreeDepths(this.tree, this.treeLikelihood.getBranchRateModel(), d);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (variable == this.dataModel.getExtensionPrecision() || variable == this.diffusionModel.getPrecisionParameter());
        this.varianceKnown = false;
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        assert (model == this.tree || model == this.diffusionProcessDelegate);
        if (model == this.tree) {
            if (!this.isTreeRandom.booleanValue()) {
                throw new IllegalStateException("Attempting to change a fixed tree");
            }
            this.treeKnown = false;
        }
        if (model == this.diffusionProcessDelegate) {
            this.varianceKnown = false;
        }
    }

    @Override
    public void modelRestored(Model model) {
    }
}

