#' Basic Virus Model
#'
#' @description A basic virus infection model with 3 compartments
#'
#' @details The model includes uninfected and infected target cells, as well as free virus. The processes that are modeled are infection, virus production, uninfected cell birth and death, infected cell and virus death.
#'
#' This code was generated by the modelbuilder R package.
#' The model is implemented as a set of stochastic equations using the adaptivetau package.

#' The following R packages need to be loaded for the function to work: adpativetau
#'
#' @param U : starting value for Uninfected cells : numeric
#' @param I : starting value for Infected cells : numeric
#' @param V : starting value for Virus : numeric
#' @param n : rate of new uninfected cell replenishment : numeric
#' @param dU : rate at which uninfected cells die : numeric
#' @param dI : rate at which infected cells die : numeric
#' @param dV : rate at which virus is cleared : numeric
#' @param b : rate at which virus infects cells : numeric
#' @param p : rate at which infected cells produce virus : numeric
#' @param g : possible conversion factor for virus units : numeric
#' @param tfinal : Final time of simulation : numeric
#' @param rngseed : set random number seed for reproducibility : numeric
#' @return The function returns the output as a list.
#' The time-series from the simulation is returned as a dataframe saved as list element \code{ts}.
#' The \code{ts} dataframe has one column per compartment/variable. The first column is time.
#' @examples
#' # To run the simulation with default parameters:
#' result <- simulate_Basic_Virus_Model_stochastic()
#' # To choose values other than the standard one, specify them like this:
#' result <- simulate_Basic_Virus_Model_stochastic(U = 2e+05,I = 0,V = 2)
#' # You can display or further process the result, like this:
#' plot(result$ts[,'time'],result$ts[,'U'],xlab='Time',ylab='Numbers',type='l')
#' print(paste('Max number of U: ',max(result$ts[,'U'])))
#' @section Warning: This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
#' @section Model Author: Andreas Handel
#' @section Model creation date: 2021-07-19
#' @section Code Author: generated by the \code{modelbuilder} R package
#' @section Code creation date: 2021-07-19
#' @export

simulate_Basic_Virus_Model_stochastic <- function(U = 1e+05, I = 0, V = 1, n = 0, dU = 0, dI = 1, dV = 2, b = 2e-05, p = 5, g = 1, tfinal = 30, rngseed = 123)
{
  #Block of ODE equations for adaptivetau
  Basic_Virus_Model_fct <- function(y, parms, t)
  {
    with(as.list(c(y,parms)),
     {
       #specify each rate/transition/reaction that can happen in the system
     rates = c(b*V*U, b*g*V*U, dI*I, dU*U, dV*V, n, p*I)
     return(rates)
      }
	 	)
  } # end function specifying rates used by adaptive tau

   #specify for each reaction/rate/transition how the different variables change
  #needs to be in exactly the same order as the rates listed in the rate function
  transitions = list(c(I = +1,U = -1),
 	 	 				c(V = -1),
 	 	 				c(I = -1),
 	 	 				c(U = -1),
 	 	 				c(V = -1),
 	 	 				c(U = +1),
 	 	 				c(V = +1))

  ##############################
  #Main function code block
  ##############################
  set.seed(rngseed) #set random number seed for reproducibility
  #Creating named vectors
  varvec = c(U = U, I = I, V = V)
  parvec = c(n = n, dU = dU, dI = dI, dV = dV, b = b, p = p, g = g)
  #Running the model
  simout = adaptivetau::ssa.adaptivetau(init.values = varvec, transitions = transitions,
                  	 	 	 rateFunc = Basic_Virus_Model_fct, params = parvec, tf = tfinal)
  #Setting up empty list and returning result as data frame called ts
  result <- list()
  result$ts <- as.data.frame(simout)
  return(result)
}


