/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.rdf.model.ModelFactory;

public class ConnectionDescription {
    public final String dbURL;
    public final String dbUser;
    public final String dbPassword;
    public final String dbType;
    protected IDBConnection connection;

    public ConnectionDescription(String dbURL, String dbUser, String dbPassword, String dbType) {
        this.dbURL = dbURL;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        this.dbType = dbType;
    }

    public IDBConnection getConnection() {
        if (this.connection == null) {
            this.connection = ModelFactory.createSimpleRDBConnection(this.dbURL, this.dbUser, this.dbPassword, this.dbType);
        }
        return this.connection;
    }

    public static ConnectionDescription create(String dbURL, String dbUser, String dbPassword, String dbType) {
        return new ConnectionDescription(dbURL, dbUser, dbPassword, dbType);
    }

    public String toString() {
        return "UrConnection( url=" + this.dbURL + " type=" + this.dbType + " user=" + this.dbUser + " password=" + this.dbPassword + (this.connection == null ? " unopened" : " opened") + ")";
    }
}

