/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.smarts.SmartsPattern;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class KierHallSmartsDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static String[] names;
    private static final SmartsPattern[] SMARTS;

    public KierHallSmartsDescriptor() {
        String[] tmp = EStateFragments.getNames();
        names = new String[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            KierHallSmartsDescriptor.names[i] = "khs." + tmp[i];
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#kierHallSmarts", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params != null) {
            throw new CDKException("Must not supply any parameters");
        }
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        IntegerArrayResult result = new IntegerArrayResult();
        for (int i = 0; i < SMARTS.length; ++i) {
            result.add(0);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer atomContainer;
        if (container == null || container.getAtomCount() == 0) {
            return this.getDummyDescriptorValue(new CDKException("Container was null or else had no atoms"));
        }
        try {
            atomContainer = container.clone();
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getImplicitHydrogenCount() != null) continue;
                atom.setImplicitHydrogenCount(0);
            }
            atomContainer = AtomContainerManipulator.removeHydrogens(atomContainer);
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(new CDKException("Error during clone"));
        }
        int[] counts = new int[SMARTS.length];
        SmartsPattern.prepare(atomContainer);
        for (int i = 0; i < SMARTS.length; ++i) {
            counts[i] = SMARTS[i].matchAll(atomContainer).countUnique();
        }
        IntegerArrayResult result = new IntegerArrayResult();
        int[] nArray = counts;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            result.add(i2);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(SMARTS.length);
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    static {
        SMARTS = EStateFragments.getPatterns();
    }
}

