/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.chartPanel;

import dmLab.gui.chartPanel.DataSeries;
import dmLab.gui.chartPanel.LineChart;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class JLineChart
extends LineChart {
    private XYSeriesCollection myDataset;
    private ArrayList<Boolean> seriesMainAxisIndicator;
    private Color[] colors = new Color[]{Color.red, Color.blue, Color.black, Color.green, Color.magenta, Color.yellow, Color.orange, Color.gray};
    private boolean axis2ON = true;

    /*
     * WARNING - void declaration
     */
    public JLineChart(String chartTitle, int imageWidth, int imageHeight) {
        super((String)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BufferedImage draw(ArrayList<DataSeries> series) {
        int i = 0;
        while (i < series.size()) {
            DataSeries s = series.get(i);
            if (i == 0) {
                this.addSeries(s.seriesTitle, s.x, s.y, s.mainAxis, true);
            } else {
                void var3_3;
                this.addSeries(s.seriesTitle, s.x, s.y, var3_3.mainAxis, false);
            }
            ++i;
        }
        return this.redraw();
    }

    @Override
    public final BufferedImage redraw() {
        if (this.myDataset == null) {
            return null;
        }
        JLineChart jLineChart = this;
        jLineChart = jLineChart.createChart((Dataset)jLineChart.myDataset);
        return jLineChart.createBufferedImage(this.imgWidth, this.imgHeight, null);
    }

    private void addSeries(String seriesTitle, float[] x, float[] y, boolean mainAxis, boolean flushDataset) {
        if (flushDataset || this.myDataset == null) {
            this.myDataset = new XYSeriesCollection();
            this.seriesMainAxisIndicator = new ArrayList();
        }
        XYSeries series = new XYSeries((Comparable)((Object)seriesTitle));
        series.setDescription(seriesTitle);
        int i = 0;
        while (i < x.length) {
            series.add((double)x[i], (double)y[i]);
            ++i;
        }
        this.myDataset.addSeries(series);
        this.seriesMainAxisIndicator.add(mainAxis);
    }

    private JFreeChart createChart(Dataset dataset) {
        XYSeries series;
        XYSeriesCollection datasetMainAxis;
        int colorIndex = 0;
        boolean legendOn = false;
        if (((XYSeriesCollection)dataset).getSeriesCount() > 1) {
            legendOn = true;
        }
        XYSeriesCollection datasetSecondAxis = null;
        if (this.axis2ON) {
            datasetMainAxis = new XYSeriesCollection();
            datasetSecondAxis = new XYSeriesCollection();
            int size = ((XYSeriesCollection)dataset).getSeriesCount();
            int i = 0;
            while (i < size) {
                series = ((XYSeriesCollection)dataset).getSeries(i);
                if (this.seriesMainAxisIndicator.get(i).booleanValue()) {
                    datasetMainAxis.addSeries(series);
                } else {
                    datasetSecondAxis.addSeries(series);
                }
                ++i;
            }
        } else {
            datasetMainAxis = (XYSeriesCollection)dataset;
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.chartTitle, (String)this.xLabel, (String)this.yLabel, (XYDataset)datasetMainAxis, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legendOn, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer rendererMain = new XYLineAndShapeRenderer();
        int seriesNumber = datasetMainAxis.getSeriesCount();
        int i22 = 0;
        while (i22 < seriesNumber) {
            rendererMain.setSeriesPaint(i22, (Paint)this.colors[colorIndex++]);
            rendererMain.setSeriesLinesVisible(i22, true);
            rendererMain.setSeriesShapesVisible(i22, false);
            ++i22;
        }
        plot.setRenderer((XYItemRenderer)rendererMain);
        NumberAxis i22 = (NumberAxis)plot.getRangeAxis();
        i22.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (this.axis2ON) {
            seriesNumber = datasetSecondAxis.getSeriesCount();
            String secondAxisLabel = "";
            int i = 0;
            while (i < seriesNumber) {
                series = datasetSecondAxis.getSeries(i);
                if (i != 0) {
                    secondAxisLabel = String.valueOf(secondAxisLabel) + "/";
                }
                secondAxisLabel = String.valueOf(secondAxisLabel) + series.getDescription();
                ++i;
            }
            NumberAxis axis2 = new NumberAxis(String.valueOf(secondAxisLabel) + " values");
            axis2.setAutoRangeIncludesZero(false);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setDataset(1, (XYDataset)datasetSecondAxis);
            plot.mapDatasetToRangeAxis(1, 1);
            XYLineAndShapeRenderer rendererSecondAxis = new XYLineAndShapeRenderer();
            int i3 = 0;
            while (i3 < seriesNumber) {
                rendererSecondAxis.setSeriesPaint(i3, (Paint)this.colors[colorIndex++]);
                rendererSecondAxis.setSeriesLinesVisible(i3, true);
                rendererSecondAxis.setSeriesShapesVisible(i3, false);
                ++i3;
            }
            plot.setRenderer(1, (XYItemRenderer)rendererSecondAxis);
        }
        return chart;
    }
}

