/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Exponential;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class GEV
extends GenericDistribution {
    protected double loc;
    protected double scale;
    protected double shape;

    public static final double density(double x, double loc, double scale, double shape, boolean log) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        x = (x - loc) / scale;
        x = shape == 0.0 ? -Math.log(scale) - x - Math.exp(-x) : ((x = 1.0 + shape * x) <= 0.0 ? Double.NEGATIVE_INFINITY : -Math.log(scale) - Math.pow(x, -1.0 / shape) - (1.0 / shape + 1.0) * Math.log(x));
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, double loc, double scale, double shape, boolean lower_tail) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        q = (q - loc) / scale;
        q = shape == 0.0 ? Math.exp(-Math.exp(-q)) : Math.pow(Math.exp(Math.max(1.0 + shape * q, 0.0)), -1.0 / shape);
        return !lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, double loc, double scale, double shape, boolean lower_tail) {
        if (p <= 0.0 || p >= 1.0 || scale < 0.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return shape == 0.0 ? loc - scale * Math.log(-Math.log(p)) : loc + scale * ((Math.pow(-Math.log(p), -shape) - 1.0) / shape);
    }

    public static final double random(double loc, double scale, double shape, RandomEngine random) {
        if (scale < 0.0) {
            return Double.NaN;
        }
        return shape == 0.0 ? loc - scale * Math.log(Exponential.random_standard(random)) : loc + scale * ((Math.pow(Exponential.random_standard(random), -shape) - 1.0) / shape);
    }

    public static final double[] random(int n, double loc, double scale, double shape, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = GEV.random(loc, scale, shape, random);
            ++i;
        }
        return rand;
    }

    public GEV(double loc, double scale, double shape) {
        this.loc = loc;
        this.scale = scale;
        this.shape = shape;
    }

    public double density(double x, boolean log) {
        return GEV.density(x, this.loc, this.scale, this.shape, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = GEV.cumulative(p, this.loc, this.scale, this.shape, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        return GEV.quantile(q, this.loc, this.scale, this.shape, lower_tail);
    }

    public double random() {
        return GEV.random(this.loc, this.scale, this.shape, this.random);
    }
}

