/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.DefineFunction;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.Function;
import weka.core.pmml.TransformationDictionary;

class Apply
extends Expression {
    private static final long serialVersionUID = -2790648331300695083L;
    protected ArrayList<Expression> m_arguments = new ArrayList();
    protected Function m_function = null;
    protected Attribute m_outputStructure = null;

    protected Apply(Element apply, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs, TransformationDictionary transDict) throws Exception {
        super(opType, fieldDefs);
        String functionName = apply.getAttribute("function");
        if (functionName == null || functionName.length() == 0) {
            functionName = apply.getAttribute("name");
        }
        if (functionName == null || functionName.length() == 0) {
            throw new Exception("[Apply] No function name specified!!");
        }
        this.m_function = Function.getFunction(functionName, transDict);
        NodeList children = apply.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Expression tempExpression;
            String tagName;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && !(tagName = ((Element)child).getTagName()).equals("Extension") && (tempExpression = Expression.getExpression(tagName, child, this.m_opType, this.m_fieldDefs, transDict)) != null) {
                this.m_arguments.add(tempExpression);
            }
            ++i;
        }
        this.updateDefsForArgumentsAndFunction();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        super.setFieldDefs(fieldDefs);
        this.updateDefsForArgumentsAndFunction();
    }

    private void updateDefsForArgumentsAndFunction() throws Exception {
        int i = 0;
        while (i < this.m_arguments.size()) {
            this.m_arguments.get(i).setFieldDefs(this.m_fieldDefs);
            ++i;
        }
        ArrayList<Attribute> functionFieldDefs = new ArrayList<Attribute>(this.m_arguments.size());
        int i2 = 0;
        while (i2 < this.m_arguments.size()) {
            functionFieldDefs.add(this.m_arguments.get(i2).getOutputDef());
            ++i2;
        }
        this.m_function.setParameterDefs(functionFieldDefs);
        this.m_outputStructure = this.m_function.getOutputDef();
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        double[] functionIncoming = new double[this.m_arguments.size()];
        int i = 0;
        while (i < this.m_arguments.size()) {
            functionIncoming[i] = this.m_arguments.get(i).getResult(incoming);
            ++i;
        }
        double result = this.m_function.getResult(functionIncoming);
        return result;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new IllegalArgumentException("[Apply] Can't return result as categorical/ordinal because optype is continuous!");
        }
        double result = this.getResult(incoming);
        return this.m_outputStructure.value((int)result);
    }

    @Override
    public Attribute getOutputDef() {
        return this.m_outputStructure;
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        String[] parameterNames = null;
        buff.append(String.valueOf(pad) + "Apply [" + this.m_function.toString() + "]:\n");
        buff.append(String.valueOf(pad) + "args:");
        if (this.m_function instanceof DefineFunction) {
            parameterNames = this.m_function.getParameterNames();
        }
        int i = 0;
        while (i < this.m_arguments.size()) {
            Expression e = this.m_arguments.get(i);
            buff.append("\n" + (parameterNames != null ? String.valueOf(pad) + parameterNames[i] + " = " : "") + e.toString(String.valueOf(pad) + "  "));
            ++i;
        }
        return buff.toString();
    }
}

