/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.filters.unsupervised.attribute.AbstractTimeSeries;

public class TimeSeriesTranslate
extends AbstractTimeSeries {
    static final long serialVersionUID = -8901621509691785705L;

    public String globalInfo() {
        return "An instance filter that assumes instances form time-series data and replaces attribute values in the current instance with the equivalent attribute values of some previous (or future) instance. For instances where the desired value is unknown either the instance may be dropped, or missing values used. Skips the class attribute if it is set.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (instanceInfo.classIndex() > 0 && !this.getFillWithMissing()) {
            throw new IllegalArgumentException("TimeSeriesTranslate: Need to fill in missing values using appropriate option when class index is set.");
        }
        super.setInputFormat(instanceInfo);
        Instances outputFormat = new Instances(instanceInfo, 0);
        int i = 0;
        while (i < instanceInfo.numAttributes()) {
            if (i != instanceInfo.classIndex() && this.m_SelectedCols.isInRange(i)) {
                if (outputFormat.attribute(i).isNominal() || outputFormat.attribute(i).isNumeric()) {
                    outputFormat.renameAttribute(i, String.valueOf(outputFormat.attribute(i).name()) + (this.m_InstanceRange < 0 ? (char)'-' : '+') + Math.abs(this.m_InstanceRange));
                } else {
                    throw new UnsupportedAttributeTypeException("Only numeric and nominal attributes may be  manipulated in time series.");
                }
            }
            ++i;
        }
        outputFormat.setClassIndex(instanceInfo.classIndex());
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    protected Instance mergeInstances(Instance source, Instance dest) {
        Instances outputFormat = this.outputFormatPeek();
        double[] vals = new double[outputFormat.numAttributes()];
        int i = 0;
        while (i < vals.length) {
            vals[i] = i != outputFormat.classIndex() && this.m_SelectedCols.isInRange(i) ? (source != null ? source.value(i) : Instance.missingValue()) : dest.value(i);
            ++i;
        }
        Instance inst = null;
        inst = dest instanceof SparseInstance ? new SparseInstance(dest.weight(), vals) : new Instance(dest.weight(), vals);
        inst.setDataset(dest.dataset());
        return inst;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5547 $");
    }

    public static void main(String[] argv) {
        TimeSeriesTranslate.runFilter(new TimeSeriesTranslate(), argv);
    }
}

