/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.swing.file_chooser.FileInfos;
import com.qarks.util.ui.swing.file_chooser.FileTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class FileCellRenderer
extends JPanel
implements TreeCellRenderer,
ListCellRenderer,
TableCellRenderer {
    private FileView mFileView = null;
    private JLabel mIconLabel = null;
    private JLabel mTextLabel = null;

    public FileCellRenderer(FileView fileView) {
        super(new BorderLayout(3, 0));
        this.mFileView = fileView;
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.mIconLabel = new JLabel();
        this.mIconLabel.setOpaque(true);
        this.mIconLabel.setBackground(Color.white);
        this.mIconLabel.setIconTextGap(0);
        this.mIconLabel.setVerticalTextPosition(0);
        this.mIconLabel.setHorizontalTextPosition(4);
        this.mIconLabel.setVerticalAlignment(0);
        this.mIconLabel.setHorizontalAlignment(10);
        this.mTextLabel = new JLabel("dummy");
        this.mTextLabel.setOpaque(true);
        this.mTextLabel.setIconTextGap(0);
        this.mTextLabel.setVerticalTextPosition(0);
        this.mTextLabel.setHorizontalTextPosition(4);
        this.mTextLabel.setVerticalAlignment(0);
        this.mTextLabel.setHorizontalAlignment(10);
        this.add((Component)this.mIconLabel, "Before");
        this.add((Component)this.mTextLabel, "Center");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        Icon icon = fileTreeNode.getIcon();
        String string = fileTreeNode.getName();
        this.mIconLabel.setIcon(icon);
        this.mTextLabel.setText(string);
        if (bl) {
            Color color = (Color)UIManager.get("Tree.selectionBackground");
            this.mTextLabel.setBackground(color);
            color = (Color)UIManager.get("List.selectionForeground");
            if (!jTree.isEnabled()) {
                color = Color.lightGray;
            }
            this.mTextLabel.setForeground(color);
        } else {
            Color color = (Color)UIManager.get("Tree.background");
            this.mTextLabel.setBackground(color);
            color = (Color)UIManager.get("Tree.foreground");
            if (!jTree.isEnabled()) {
                color = Color.lightGray;
            }
            this.mTextLabel.setForeground(color);
        }
        return this;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        File file = (File)object;
        Icon icon = this.mFileView.getIcon(file);
        String string = this.mFileView.getName(file);
        this.mIconLabel.setIcon(icon);
        this.mTextLabel.setText(string);
        if (bl) {
            Color color = (Color)UIManager.get("List.selectionBackground");
            this.mTextLabel.setBackground(color);
            color = (Color)UIManager.get("List.selectionForeground");
            this.mTextLabel.setForeground(color);
        } else {
            Color color = (Color)UIManager.get("List.background");
            this.mTextLabel.setBackground(color);
            color = (Color)UIManager.get("List.foreground");
            this.mTextLabel.setForeground(color);
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        if (object instanceof FileInfos) {
            object2 = (FileInfos)object;
            Icon icon = ((FileInfos)object2).getIcon();
            String string = ((FileInfos)object2).getName();
            this.mIconLabel.setIcon(icon);
            this.mTextLabel.setText(string);
        } else {
            this.mIconLabel.setIcon(null);
            this.mTextLabel.setText("");
        }
        if (bl) {
            object2 = (Color)UIManager.get("Table.selectionBackground");
            this.mTextLabel.setBackground((Color)object2);
            object2 = (Color)UIManager.get("Table.selectionForeground");
            this.mTextLabel.setForeground((Color)object2);
        } else {
            object2 = (Color)UIManager.get("Table.background");
            this.mTextLabel.setBackground((Color)object2);
            object2 = (Color)UIManager.get("Table.foreground");
            this.mTextLabel.setForeground((Color)object2);
        }
        return this;
    }
}

