/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntegralProxy;
import scala.runtime.OrderedProxy;
import scala.runtime.RichBoolean;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import sparklyr.Collectors$;
import sparklyr.Logger;
import sparklyr.Numeric;
import sparklyr.RawSXP;
import sparklyr.Serializer$;
import sparklyr.StructTypeAsJSON$;

public final class RUtils$ {
    public static final RUtils$ MODULE$ = new RUtils$();
    private static final char XDR_FORMAT = (char)88;
    private static final int CHARSXP = 9;
    private static final int LGLSXP = 10;
    private static final int INTSXP = 13;
    private static final int REALSXP = 14;
    private static final int STRSXP = 16;
    private static final int VECSXP = 19;
    private static final int RAWSXP = 24;
    private static final int NILVALUE_SXP = 254;
    private static final int NA_INTEGER = Integer.MIN_VALUE;

    public void validateSerializationFormat(DataInputStream dis, boolean verbose) {
        if (dis == null) {
            throw null;
        }
        char format = (char)dis.readUnsignedByte();
        dis.readUnsignedByte();
        if (XDR_FORMAT != format) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported R serialization format '").append(format).append("'").toString());
        }
        int version = dis.readInt();
        int writerVersion = dis.readInt();
        int minReaderVersion = dis.readInt();
        if (version != 2) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Unsupported R serialization version '").append(version).append("'").toString());
        }
        if (verbose) {
            Logger logger = new Logger("Utils", 0);
            logger.log(new StringBuilder(25).append("R serialization version: ").append(version).toString());
            logger.log(new StringBuilder(32).append("R serialization writer version: ").append(writerVersion).toString());
            logger.log(new StringBuilder(36).append("R serialization min reader version: ").append(minReaderVersion).toString());
            return;
        }
    }

    public boolean validateSerializationFormat$default$2() {
        return false;
    }

    public Object[] unserializeColumn(DataInputStream dis) {
        Logger logger = new Logger("RUtils", 0);
        int dtype = dis.readInt() & 0xFF;
        if (VECSXP != dtype) {
            logger.logWarning(new StringBuilder(28).append("Unexpected column data type ").append(dtype).toString());
        }
        long num_rows = this.readLength(dis);
        return (Object[])((IterableOnceOps)IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)num_rows).map((Function1 & Serializable)r -> RUtils$.$anonfun$unserializeColumn$1(dis, logger, BoxesRunTime.unboxToLong((Object)r)))).toArray(ClassTag$.MODULE$.Any());
    }

    /*
     * WARNING - void declaration
     */
    private int[] unserializeIntColumn(DataInputStream dis) {
        void var3_3;
        int fill_n = 5;
        if (fill_n <= 0) {
            return new int[0];
        }
        int[] fill_array = new int[fill_n];
        for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
            void var5_5;
            boolean boxToInteger_i = false;
            fill_array[fill_i] = var5_5;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private String[] unserializeStringColumn(DataInputStream dis) {
        void var3_3;
        int fill_n = 5;
        if (fill_n <= 0) {
            return new String[0];
        }
        String[] fill_array = new String[fill_n];
        for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
            String array_update_value;
            fill_array[fill_i] = array_update_value = "";
            Object var5_5 = null;
        }
        return var3_3;
    }

    private int readDataType(DataInputStream dis) {
        return dis.readInt() & 0xFF;
    }

    private long readLength(DataInputStream dis) {
        int x = dis.readInt();
        if (-1 == x) {
            throw new IllegalArgumentException("Vector with length greater than INT_MAX (i.e., 'LONG_VECTOR') is not supported yet");
        }
        if (x < 0) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Negative serialized vector length: ").append(x).toString());
        }
        return x;
    }

    /*
     * WARNING - void declaration
     */
    private int extractInt(byte[] bytes, int offset) {
        Integer n;
        int n2 = 0;
        int until$extension_end = 4;
        Range.Exclusive map_this = new Range.Exclusive(n2, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            int n3 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            n = (bytes[offset + n3] & 0xFF) << 24 - n3 * 8;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n = null;
        }
        Object var4_5 = null;
        Object var5_6 = null;
        Object var6_7 = null;
        n = null;
        return BoxesRunTime.unboxToInt((Object)((IndexedSeq)map_strictOptimizedMap_b.result()).reduce((Function2)(JFunction2.mcIII.sp & Serializable)(p, q) -> p | q));
    }

    private int rVersion(int v, int p, int s) {
        return v * 65536 + p * 256 + s;
    }

    /*
     * WARNING - void declaration
     */
    public void writeXdrHeader(DataOutputStream dos) {
        void rVersion_s;
        dos.writeByte(XDR_FORMAT);
        dos.writeByte(10);
        dos.writeInt(2);
        int rVersion_s2 = 0;
        int rVersion_p = 4;
        dos.writeInt(1 * 65536 + rVersion_p * 256 + rVersion_s2);
        boolean bl = false;
        int rVersion_p2 = 4;
        dos.writeInt(1 * 65536 + rVersion_p2 * 256 + rVersion_s);
    }

    /*
     * WARNING - void declaration
     */
    public void writeDataFrameHeader(DataOutputStream dos, Seq<Tuple2<String, String>> dtypes) {
        Object object;
        this.writeFlags(dos, VECSXP, 0, false, false, false);
        int writeLength_length = 5;
        dos.writeInt(writeLength_length);
        this.writeStringValues(dos, (Seq<String>)((Seq)dtypes.map((Function1 & Serializable)x -> (String)x._1())));
        ArrayBuffer timestampColIdxes = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (Seq)Nil$.MODULE$);
        ArrayBuffer dateColIdxes = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (Seq)Nil$.MODULE$);
        ArrayBuffer structColIdxes = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (Seq)Nil$.MODULE$);
        int n = 1;
        int to$extension_end = dtypes.length();
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object2 : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            object = RUtils$.$anonfun$writeDataFrameHeader$2(dtypes, timestampColIdxes, dateColIdxes, structColIdxes, BoxesRunTime.unboxToInt((Object)object2));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            object = null;
        }
        IndexedSeq cfr_ignored_0 = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_9 = null;
        Object var8_10 = null;
        Object var9_11 = null;
        object = null;
        this.writeIntValues(dos, (Seq<Object>)timestampColIdxes.toSeq());
        this.writeIntValues(dos, (Seq<Object>)dateColIdxes.toSeq());
        this.writeIntValues(dos, (Seq<Object>)structColIdxes.toSeq());
        this.writeFlags(dos, VECSXP, 0, false, false, false);
        int writeLength_length2 = dtypes.length();
        dos.writeInt(writeLength_length2);
    }

    public void writeColumn(DataOutputStream dos2, int numRows, Iterator<Row> colIter, String dtype) {
        Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3;
        if ("BooleanType".equals(dtype)) {
            function3 = this.booleanColumnWriter();
        } else if ("ByteType".equals(dtype)) {
            function3 = this.integralColumnWriter((Integral)Numeric.ByteIsIntegral$.MODULE$);
        } else if ("ShortType".equals(dtype)) {
            function3 = this.integralColumnWriter((Integral)Numeric.ShortIsIntegral$.MODULE$);
        } else if ("IntegerType".equals(dtype)) {
            function3 = this.integralColumnWriter((Integral)Numeric.IntIsIntegral$.MODULE$);
        } else if ("FloatType".equals(dtype)) {
            function3 = this.numericColumnWriter((scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$);
        } else if ("LongType".equals(dtype)) {
            function3 = this.numericColumnWriter((scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if ("DoubleType".equals(dtype)) {
            function3 = this.numericColumnWriter((scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$);
        } else if (dtype != null && !Collectors$.MODULE$.ReDecimalType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = this.decimalColumnWriter();
        } else if ("StringType".equals(dtype)) {
            function3 = this.stringColumnWriter();
        } else if ("TimestampType".equals(dtype)) {
            function3 = this.timestampColumnWriter();
        } else if ("DateType".equals(dtype)) {
            function3 = this.dateColumnWriter();
        } else if (dtype != null && !Collectors$.MODULE$.ReBooleanArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(LGLSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeLglValue(dos, v);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReByteArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = this.rawColumnWriter();
        } else if (dtype != null && !Collectors$.MODULE$.ReShortArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(INTSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeIntegralValue(dos, v, (Integral)Numeric.ShortIsIntegral$.MODULE$);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReIntegerArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(INTSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeIntegralValue(dos, v, (Integral)Numeric.IntIsIntegral$.MODULE$);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReLongArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(REALSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeNumericValue(dos, v, (scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReDecimalArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(REALSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeDecimalValue(dos, v);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReFloatArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(REALSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeNumericValue(dos, v, (scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReDoubleArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(REALSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeNumericValue(dos, v, (scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReStringArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(STRSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeStringValue(dos, v);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReTimestampArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(REALSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeTimestampValue(dos, v);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else if (dtype != null && !Collectors$.MODULE$.ReDateArrayType().unapplySeq((CharSequence)dtype).isEmpty()) {
            function3 = (arg_0, arg_1, arg_2) -> RUtils$.$anonfun$arrayColumnWriter$1$adapted(INTSXP, (Function2 & Serializable)(dos, v) -> {
                RUtils$.MODULE$.writeDateValue(dos, v);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1, arg_2);
        } else {
            String string = StructTypeAsJSON$.MODULE$.DType();
            if (!(string != null ? !string.equals(dtype) : dtype != null)) {
                function3 = this.stringColumnWriter();
            } else {
                throw new IllegalArgumentException(new StringBuilder(67).append("Serializing Spark dataframe column of type '").append(dtype).append("' to RDS is unsupported").toString());
            }
        }
        function3.apply((Object)dos2, (Object)numRows, colIter);
    }

    private void writeDateValue(DataOutputStream dos, Object v) {
        Serializer$.MODULE$.writeDate(dos, Collectors$.MODULE$.extractDaysSinceEpoch(v));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> booleanColumnWriter() {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$booleanColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeLglValue(DataOutputStream dos, Object v) {
        int n;
        if (v == null) {
            n = NA_INTEGER;
        } else {
            boolean b = BoxesRunTime.unboxToBoolean((Object)v);
            n = OrderedProxy.compare$((OrderedProxy)new RichBoolean(b), (Object)false);
        }
        dos.writeInt(n);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> rawColumnWriter() {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$rawColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private <SrcType> Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> integralColumnWriter(Integral<SrcType> evidence$1) {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$integralColumnWriter$1(evidence$1, dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeIntValues(DataOutputStream dos, Seq<Object> vals) {
        this.writeFlags(dos, INTSXP, 0, false, false, false);
        int writeLength_length = vals.length();
        dos.writeInt(writeLength_length);
        vals.map((Function1)(JFunction1.mcVI.sp & Serializable)x -> MODULE$.writeIntegralValue(dos, BoxesRunTime.boxToInteger((int)x), (Integral)Numeric.IntIsIntegral$.MODULE$));
    }

    private <SrcType> void writeIntegralValue(DataOutputStream dos, Object v, Integral<SrcType> evidence$2) {
        dos.writeInt(v == null ? NA_INTEGER : evidence$2.toInt(v));
    }

    private void writeRawValue(DataOutputStream dos, Object v) {
        this.writeFlags(dos, RAWSXP, 0, false, false, false);
        if (v == null) {
            int writeLength_length = -1;
            dos.writeInt(writeLength_length);
            return;
        }
        Object buf = ((ArraySeq)v).array();
        int writeLength_length = Array.getLength(buf);
        dos.writeInt(writeLength_length);
        byte[] byteArray = new byte[Array.getLength(buf)];
        Range range = ArrayOps$.MODULE$.indices$extension(buf);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                byteArray[foreach$mVc$sp_i] = BoxesRunTime.unboxToByte((Object)ScalaRunTime$.MODULE$.array_apply(buf, foreach$mVc$sp_i));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var5_7 = null;
        dos.write(byteArray);
    }

    private <SrcType> Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> numericColumnWriter(scala.math.Numeric<SrcType> evidence$3) {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$numericColumnWriter$1(evidence$3, dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private <SrcType> void writeNumericValue(DataOutputStream dos, Object v, scala.math.Numeric<SrcType> evidence$4) {
        None$ none$;
        if (v == null) {
            none$ = None$.MODULE$;
        } else {
            double boxToDouble_d = evidence$4.toDouble(v);
            Some some = new Some((Object)new Double(boxToDouble_d));
            none$ = some;
        }
        Serializer$.MODULE$.writeNumeric(dos, new Numeric((Option<Object>)none$));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> decimalColumnWriter() {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$decimalColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeDecimalValue(DataOutputStream dos, Object v) {
        None$ none$;
        if (v instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)v;
            double boxToDouble_d = bigDecimal.doubleValue();
            Some some = new Some((Object)new Double(boxToDouble_d));
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        Serializer$.MODULE$.writeNumeric(dos, new Numeric((Option<Object>)none$));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> stringColumnWriter() {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$stringColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> timestampColumnWriter() {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$timestampColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeTimestampValue(DataOutputStream dos, Object v) {
        double d;
        if (v instanceof Date) {
            Date date = (Date)v;
            d = Serializer$.MODULE$.timestampToSeconds(date);
        } else {
            d = Double.NaN;
        }
        dos.writeDouble(d);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> dateColumnWriter() {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$dateColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeStringValues(DataOutputStream dos, Seq<String> vals) {
        this.writeFlags(dos, STRSXP, 0, false, false, false);
        int writeLength_length = vals.length();
        dos.writeInt(writeLength_length);
        vals.map((Function1 & Serializable)x -> {
            RUtils$.MODULE$.writeStringValue(dos, x);
            return BoxedUnit.UNIT;
        });
    }

    private void writeStringValue(DataOutputStream dos, Object v) {
        this.writeFlags(dos, CHARSXP, 0, false, false, false);
        if (v instanceof String) {
            String string = (String)v;
            Serializer$.MODULE$.writeString(dos, string);
            return;
        }
        int writeLength_length = -1;
        dos.writeInt(writeLength_length);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> arrayColumnWriter(int elemType, Function2<DataOutputStream, Object, BoxedUnit> elemWriter) {
        return (Function3 & Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$arrayColumnWriter$1(elemType, elemWriter, dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeFlags(DataOutputStream dos, int dtype, int levels, boolean isObj, boolean hasAttr, boolean hasTag) {
        dos.writeInt(dtype & 0xFF | OrderedProxy.compare$((OrderedProxy)new RichBoolean(isObj), (Object)false) << 8 | OrderedProxy.compare$((OrderedProxy)new RichBoolean(hasAttr), (Object)false) << 9 | OrderedProxy.compare$((OrderedProxy)new RichBoolean(hasTag), (Object)false) << 10 | levels << 12);
    }

    private int writeFlags$default$3() {
        return 0;
    }

    private boolean writeFlags$default$4() {
        return false;
    }

    private boolean writeFlags$default$5() {
        return false;
    }

    private boolean writeFlags$default$6() {
        return false;
    }

    private void writeLength(DataOutputStream dos, int length) {
        dos.writeInt(length);
    }

    public static final /* synthetic */ Object $anonfun$unserializeColumn$1(DataInputStream dis$1, Logger logger$1, long r) {
        int elem_dtype = dis$1.readInt() & 0xFF;
        if (NILVALUE_SXP == elem_dtype) {
            return null;
        }
        long num_elems = MODULE$.readLength(dis$1);
        if (RAWSXP == elem_dtype) {
            byte[] bytes = new byte[(int)num_elems];
            dis$1.readFully(bytes, 0, bytes.length);
            return new RawSXP(bytes);
        }
        if (1L != num_elems) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Unexpected number of elements: ").append(num_elems).toString());
        }
        if (LGLSXP == elem_dtype) {
            int v = dis$1.readInt();
            if (NA_INTEGER == v) {
                return null;
            }
            return v != 0;
        }
        if (INTSXP == elem_dtype) {
            int v = dis$1.readInt();
            if (NA_INTEGER == v) {
                return null;
            }
            return v;
        }
        if (REALSXP == elem_dtype) {
            byte[] bytes = new byte[8];
            dis$1.readFully(bytes, 0, bytes.length);
            long hw = (long)MODULE$.extractInt(bytes, 0) & 0xFFFFFFFFL;
            long lw = (long)MODULE$.extractInt(bytes, 4) & 0xFFFFFFFFL;
            if (hw == 0x7FF00000L && lw == 1954L) {
                return null;
            }
            double boxToDouble_d = Double.longBitsToDouble(hw << 32 | lw);
            return new Double(boxToDouble_d);
        }
        if (STRSXP == elem_dtype) {
            int strlen;
            int ctype = dis$1.readInt() & 0xFF;
            if (CHARSXP != ctype) {
                logger$1.logWarning(new StringBuilder(53).append("Unexpected character type ").append(ctype).append(" found in string expression").toString());
            }
            if (-1L == (long)(strlen = dis$1.readInt())) {
                return null;
            }
            byte[] bytes = new byte[strlen];
            dis$1.readFully(bytes, 0, bytes.length);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(elem_dtype).toString());
    }

    public static final /* synthetic */ int $anonfun$unserializeIntColumn$1() {
        return 0;
    }

    public static final /* synthetic */ String $anonfun$unserializeStringColumn$1() {
        return "";
    }

    public static final /* synthetic */ int $anonfun$extractInt$1(byte[] bytes$1, int offset$1, int i) {
        return (bytes$1[offset$1 + i] & 0xFF) << 24 - i * 8;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$writeDataFrameHeader$2(Seq dtypes$1, ArrayBuffer timestampColIdxes$1, ArrayBuffer dateColIdxes$1, ArrayBuffer structColIdxes$1, int idx) {
        String colType = (String)((Tuple2)dtypes$1.apply(idx - 1))._2();
        if ("TimestampType".equals(colType)) {
            void $plus$eq_elem;
            Integer n = idx;
            if (timestampColIdxes$1 == null) {
                throw null;
            }
            return timestampColIdxes$1.addOne((Object)$plus$eq_elem);
        }
        if ("DateType".equals(colType)) {
            void $plus$eq_elem;
            Integer n = idx;
            if (dateColIdxes$1 == null) {
                throw null;
            }
            return dateColIdxes$1.addOne((Object)$plus$eq_elem);
        }
        if (colType != null && !Collectors$.MODULE$.ReTimestampArrayType().unapplySeq((CharSequence)colType).isEmpty()) {
            void $plus$eq_elem;
            Integer n = idx;
            if (timestampColIdxes$1 == null) {
                throw null;
            }
            return timestampColIdxes$1.addOne((Object)$plus$eq_elem);
        }
        if (colType != null && !Collectors$.MODULE$.ReDateArrayType().unapplySeq((CharSequence)colType).isEmpty()) {
            void $plus$eq_elem;
            Integer n = idx;
            if (dateColIdxes$1 == null) {
                throw null;
            }
            return dateColIdxes$1.addOne((Object)$plus$eq_elem);
        }
        String string = StructTypeAsJSON$.MODULE$.DType();
        if (!(string != null ? !string.equals(colType) : colType != null)) {
            void $plus$eq_elem;
            Integer n = idx;
            if (structColIdxes$1 == null) {
                throw null;
            }
            return structColIdxes$1.addOne((Object)$plus$eq_elem);
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$booleanColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, LGLSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeLglValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$rawColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, VECSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeRawValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$integralColumnWriter$1(Integral evidence$1$1, DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, INTSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeIntegralValue(dos, row.get(0), evidence$1$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeRawValue$1(byte[] byteArray$1, Object buf$1, int i) {
        byteArray$1[i] = BoxesRunTime.unboxToByte((Object)ScalaRunTime$.MODULE$.array_apply(buf$1, i));
    }

    public static final /* synthetic */ void $anonfun$numericColumnWriter$1(scala.math.Numeric evidence$3$1, DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, REALSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeNumericValue(dos, row.get(0), evidence$3$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$decimalColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, REALSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeDecimalValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$stringColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, STRSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeStringValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$timestampColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, REALSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeTimestampValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dateColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, INTSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            RUtils$.MODULE$.writeDateValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$arrayColumnWriter$1(int elemType$1, Function2 elemWriter$1, DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, VECSXP, 0, false, false, false);
        dos.writeInt(numRows);
        colIter.foreach((Function1 & Serializable)row -> {
            Object v = row.get(0);
            if (v == null) {
                MODULE$.writeFlags(dos, NILVALUE_SXP, 0, false, false, false);
                return BoxedUnit.UNIT;
            }
            ArraySeq arr = (ArraySeq)v;
            MODULE$.writeFlags(dos, elemType$1, 0, false, false, false);
            int writeLength_length = arr.length();
            dos.writeInt(writeLength_length);
            Builder map_strictOptimizedMap_b = ArraySeq$.MODULE$.untagged().newBuilder();
            for (Object object : arr) {
                void map_strictOptimizedMap_$plus$eq_elem;
                elemWriter$1.apply((Object)dos, object);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                boxedUnit = null;
            }
            return map_strictOptimizedMap_b.result();
        });
    }

    private RUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$writeDataFrameHeader$2$adapted(Seq dtypes$1, ArrayBuffer timestampColIdxes$1, ArrayBuffer dateColIdxes$1, ArrayBuffer structColIdxes$1, Object idx) {
        return RUtils$.$anonfun$writeDataFrameHeader$2(dtypes$1, timestampColIdxes$1, dateColIdxes$1, structColIdxes$1, BoxesRunTime.unboxToInt((Object)idx));
    }

    public static final /* synthetic */ Object $anonfun$arrayColumnWriter$3$adapted(Function2 elemWriter$1, DataOutputStream dos$11, Object b) {
        elemWriter$1.apply((Object)dos$11, b);
        return BoxedUnit.UNIT;
    }
}

