/*
 * Decompiled with CFR 0.152.
 */
package OptimalExperimentalDesign;

import ExperimentalDesign.AllExperimentalDesigns;
import ExperimentalDesign.Tools;
import ObjectiveFunctions.AbsSumObjective;
import ObjectiveFunctions.KernelObjective;
import ObjectiveFunctions.MahalObjective;
import ObjectiveFunctions.ObjectiveFunction;
import ObjectiveFunctions.SimpleAverageObjectiveFunction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class OptimalExperimentalDesign
extends AllExperimentalDesigns {
    private static final double NOT_REACHED_YET = -999999.0;
    private static final int BATCH_SIZE = 100000;
    private static HashMap<Integer, ArrayList<BitSet>> all_indicTs = new HashMap();
    private int max_designs;
    private int n_over_two;
    private double[] objective_vals;
    private int d_opt;

    public static void main(String[] stringArray) throws Exception {
        for (int i = 1; i <= 1; ++i) {
            OptimalExperimentalDesign optimalExperimentalDesign = new OptimalExperimentalDesign();
            optimalExperimentalDesign.rand_obj.setSeed(1984L);
            int n = 6;
            int n2 = i;
            optimalExperimentalDesign.setN(n);
            optimalExperimentalDesign.setP(n2);
            for (int j = 0; j < n; ++j) {
                double[] dArray = new double[n2];
                for (int k = 0; k < n2; ++k) {
                    dArray[k] = optimalExperimentalDesign.rand_obj.nextDouble();
                }
                optimalExperimentalDesign.setDataRow(j, dArray);
            }
            optimalExperimentalDesign.setObjective("abs_sum_diff");
            optimalExperimentalDesign.setNumCores(3);
            optimalExperimentalDesign.setWait();
            optimalExperimentalDesign.beginSearch();
        }
    }

    @Override
    public void beginSearch() {
        int n;
        super.beginSearch();
        this.initializeStartingIndicTs();
        this.objective_vals = new double[this.max_designs];
        for (n = 0; n < this.max_designs; ++n) {
            this.objective_vals[n] = -999999.0;
        }
        for (n = 0; n < this.max_designs; n += 100000) {
            final int n2 = n;
            this.search_thread_pool.execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = n2; i < n2 + 100000 && i < OptimalExperimentalDesign.this.max_designs; ++i) {
                        if (i % 1000000 == 0 && OptimalExperimentalDesign.this.verbose) {
                            System.out.println("million");
                        }
                        ObjectiveFunction objectiveFunction = null;
                        if (OptimalExperimentalDesign.this.objective.equals("mahal_dist")) {
                            objectiveFunction = new MahalObjective(OptimalExperimentalDesign.this.Sinv, OptimalExperimentalDesign.this.n);
                        } else if (OptimalExperimentalDesign.this.objective.equals("abs_sum_diff")) {
                            objectiveFunction = new AbsSumObjective();
                        } else if (OptimalExperimentalDesign.this.objective.equals("kernel")) {
                            objectiveFunction = new KernelObjective(OptimalExperimentalDesign.this.Kgram);
                        }
                        BitSet bitSet = (BitSet)((ArrayList)all_indicTs.get(OptimalExperimentalDesign.this.n)).get(i);
                        int[] nArray = Tools.convert_bitvector_to_intvector(bitSet, OptimalExperimentalDesign.this.n);
                        if (OptimalExperimentalDesign.this.objective.equals("kernel")) {
                            ((KernelObjective)objectiveFunction).setW(nArray);
                        } else {
                            int[] nArray2 = Tools.findIndicies(nArray, OptimalExperimentalDesign.this.n_over_two, 1);
                            int[] nArray3 = Tools.findIndicies(nArray, OptimalExperimentalDesign.this.n - OptimalExperimentalDesign.this.n_over_two, 0);
                            ArrayList<double[]> arrayList = Tools.subsetMatrix(OptimalExperimentalDesign.this.X, nArray2);
                            ArrayList<double[]> arrayList2 = Tools.subsetMatrix(OptimalExperimentalDesign.this.X, nArray3);
                            double[] dArray = Tools.colAvg(arrayList, OptimalExperimentalDesign.this.p);
                            double[] dArray2 = Tools.colAvg(arrayList2, OptimalExperimentalDesign.this.p);
                            ((SimpleAverageObjectiveFunction)objectiveFunction).setXTbar(dArray);
                            ((SimpleAverageObjectiveFunction)objectiveFunction).setXCbar(dArray2);
                        }
                        if (i < OptimalExperimentalDesign.this.max_designs) {
                            ((OptimalExperimentalDesign)OptimalExperimentalDesign.this).objective_vals[i] = objectiveFunction.calc(false);
                        }
                        if (OptimalExperimentalDesign.this.search_stopped.get()) break;
                    }
                }
            });
        }
        this.afterBeginSearch();
        this.d_opt = Tools.min_index(this.objective_vals);
        if (this.verbose) {
            System.out.println("size of space: " + this.max_designs);
            System.out.println("d_opt: " + (this.d_opt + 1));
            System.out.println("obj_opt: " + this.objective_vals[this.d_opt]);
            System.out.println("time elapsed in sec: " + this.timeElapsedInSeconds());
        }
    }

    private void initializeStartingIndicTs() {
        if (all_indicTs.containsKey(this.n)) {
            this.max_designs = all_indicTs.get(this.n).size();
            return;
        }
        this.max_designs = (int)this.n_choose_k(this.n, this.n / 2);
        all_indicTs.put(this.n, new ArrayList(this.max_designs));
        this.recursivelyFindAllBinaryVecs(new BitSet(), 0, 0, 0);
    }

    private void recursivelyFindAllBinaryVecs(BitSet bitSet, int n, int n2, int n3) {
        if (n == this.n) {
            all_indicTs.get(this.n).add(bitSet);
            if (all_indicTs.size() % 1000000 == 0 && this.verbose) {
                System.out.println("million");
            }
            return;
        }
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.set(n, true);
        if (n2 + 1 <= this.n_over_two) {
            this.recursivelyFindAllBinaryVecs(bitSet2, n + 1, n2 + 1, n3);
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.set(n, false);
        if (n3 + 1 <= this.n_over_two) {
            this.recursivelyFindAllBinaryVecs(bitSet3, n + 1, n2, n3 + 1);
        }
    }

    private long n_choose_k(int n, int n2) {
        long l = (long)Math.floor(Math.exp(this.ln_factorial(n) - this.ln_factorial(n2) - this.ln_factorial(n - n2)));
        return l;
    }

    private double ln_factorial(int n) {
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    private int num_vectors_checked() {
        int n = 0;
        if (this.objective_vals != null) {
            for (int i = 0; i < this.max_designs && this.objective_vals[i] != -999999.0; ++i) {
                ++n;
            }
        }
        return n;
    }

    public double progress() {
        return (double)this.num_vectors_checked() / (double)this.objective_vals.length;
    }

    public double[] getObjectiveVals() {
        return this.objective_vals;
    }

    public double getOptObjectiveVal() {
        return this.objective_vals[this.d_opt];
    }

    public double[] getAllObjectiveVals() {
        return this.objective_vals;
    }

    public int[] getIndicT(int n) {
        return Tools.convert_bitvector_to_intvector(all_indicTs.get(this.n).get(n), this.n);
    }

    public int[][] getIndicTs(int[] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = this.getIndicT(nArray[i]);
        }
        return nArrayArray;
    }

    public int[] getOptIndicT() {
        return this.getIndicT(this.d_opt);
    }

    @Override
    public void setN(int n) {
        super.setN(n);
        this.n_over_two = n / 2;
    }
}

