/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import epp.EPPLab;
import epp.EvolutionPP;
import epp.ParametrePP;
import ihm.Repertoire;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javalain.algorithmegenetique.ihm.composant.JButtonEA;
import javalain.algorithmegenetique.ihm.composant.JComboBoxEA;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Bienvenue
extends JFrame {
    private Repertoire frRepertoire;
    private JButtonEA btOk;

    public Bienvenue(final EvolutionPP evolution, final ParametrePP parametre) {
        this.setTitle("Bienvenue sur EPP-Lab");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        Container conteneur = this.getContentPane();
        conteneur.setLayout(new BoxLayout(conteneur, 1));
        JEditorPane editeur = new JEditorPane();
        editeur.setEditable(false);
        editeur.setPreferredSize(new Dimension(400, 250));
        JScrollPane barre_verticale = new JScrollPane(editeur);
        barre_verticale.setVerticalScrollBarPolicy(20);
        barre_verticale.setMinimumSize(new Dimension(10, 10));
        URL message = this.getClass().getResource("/ihm/html/bienvenue.html");
        try {
            editeur.setPage(message);
        }
        catch (IOException e) {
            editeur.setText("Le fichier 'bienvenue.html' est introuvable.");
        }
        conteneur.add(barre_verticale);
        JPanel jpCde = new JPanel();
        jpCde.setLayout(new BorderLayout());
        jpCde.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        String[] langue = new String[]{"fr", "en", "es"};
        final JComboBoxEA cbLangue = new JComboBoxEA(langue);
        cbLangue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cde = (String)cbLangue.getSelectedItem();
                Locale locale = new Locale("en", "US");
                if (cde.equals("fr")) {
                    locale = new Locale("fr", "FR");
                }
                if (cde.equals("es")) {
                    locale = new Locale("es", "ES");
                }
                EPPLab.msg = ResourceBundle.getBundle("ihm/MessagesBundle", locale);
                Bienvenue.this.btOk.setText(EPPLab.msg.getString("bt.continuer"));
                Bienvenue.this.repaint();
                Bienvenue.this.pack();
            }
        });
        jpCde.add((Component)cbLangue, "West");
        this.btOk = new JButtonEA(EPPLab.msg.getString("bt.continuer"));
        this.btOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bienvenue.this.setVisible(false);
                if (Bienvenue.this.frRepertoire == null) {
                    Bienvenue.this.frRepertoire = new Repertoire(Bienvenue.this.getX(), Bienvenue.this.getY(), Bienvenue.this, evolution, parametre);
                }
                Bienvenue.this.frRepertoire.setVisible(true);
            }
        });
        jpCde.add((Component)this.btOk, "East");
        conteneur.add(jpCde);
        this.pack();
    }
}

