# covfefe 1.0.0

## Major Release - Political Linguistics Toolkit

### New Features

* **Political Linguistics Museum** (`museum.R`)
  - `museum_list()`, `museum_lookup()`, `museum_random()`
  - `museum_by_person()`, `museum_by_year()`, `museum_by_type()`
  - 13 curated digital gaffes from 1992-2025

* **Keyboard Geometry Engine** (`keyboard.R`)
  - `qwerty_distance()`, `qwerty_adjacent()`, `is_keyboard_adjacent()`
  - `adjacent_key_typo()`, `keyboard_mash()`
  - Full QWERTY layout with adjacency data

* **Phonetic Engine** (`phonetic.R`)
  - `soundex()`, `phonetic_distance()`
  - `phonetic_shift()`, `vowel_shift()`
  - `get_phonetic_group()`

* **Syllable Engine** (`syllable.R`)
  - `syllabify()`, `syllable_count()`
  - `onset_nucleus_coda()`, `syllable_swap()`

* **Word Blending Engine** (`blend.R`)
  - `blend_words()`, `detect_blend()`, `blend_score()`

* **Text Corruption Simulator** (`corrupt.R`)
  - `corrupt_text()` with modes: keyboard, phonetic, double, truncate, swap, omit
  - `garble_sentence()`

* **Detection & Analysis** (`detect.R`)
  - `detect_typo_type()`, `suggest_corrections()`
  - `analyze_gaffe()`

### Infrastructure

* Precomputed data: `gaffes.rda`, `qwerty_layout.rda`, `qwerty_adjacency.rda`, phonetic rules
* Full test coverage with testthat 3e
* Modular file structure

# covfefe 0.2.0

* Fixed `covfefySpeech()` to write output to `tempdir()` instead of working
  directory, resolving CRAN NOTE about non-standard files in check directory.
* Updated `DESCRIPTION` to use `Authors@R` format.
* Replaced deprecated Travis CI with GitHub Actions multi-platform CI.
* Added comprehensive tests for `covfefySentence()` and `covfefySpeech()`.
* Updated to roxygen2 7.3.3 with selective imports (`@importFrom`).
* Added `Encoding: UTF-8` to DESCRIPTION.

# covfefe 0.1.0

* Initial CRAN release.
* Added `covfefy()` to transform individual words.
* Added `covfefySentence()` to transform sentences.
* Added `covfefySpeech()` to transform full speeches/texts.
