## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(kit)

## -----------------------------------------------------------------------------
x <- c(1, 3, NA, 5)
y <- c(2, NA, 4, 1)
z <- c(3, 4, 4, 1)

# Parallel sum
psum(x, y, z, na.rm = TRUE)

# Parallel mean
pmean(x, y, z, na.rm = TRUE)

## -----------------------------------------------------------------------------
df <- data.frame(a = c(1, 2, 3), b = c(4, 5, 6), c = c(7, 8, 9))
psum(df)

## -----------------------------------------------------------------------------
x <- c(1, 3, NA, 5)
y <- c(2, NA, 4, 1)
z <- c(3, 4, 4, 1)

# Parallel minimum
fpmin(x, y, z, na.rm = TRUE)

# Parallel maximum
fpmax(x, y, z, na.rm = TRUE)

# Parallel range (max - min)
prange(x, y, z, na.rm = TRUE)

## -----------------------------------------------------------------------------
# With data frames
fpmin(df)
fpmax(df)
prange(df)

## -----------------------------------------------------------------------------
primary   <- c(NA, 2, NA, 4)
secondary <- c(1, NA, 3, NA)
fallback  <- c(0, 0, 0, 0)

# Take first available value
pfirst(primary, secondary, fallback)

## -----------------------------------------------------------------------------
a <- c(TRUE, FALSE, NA, TRUE)
b <- c(TRUE, NA, TRUE, FALSE)
c <- c(NA, TRUE, FALSE, TRUE)

# Any TRUE per row?
pany(a, b, c, na.rm = TRUE)

# Count NAs per row
pcountNA(a, b, c)

# Count specific value (e.g., TRUE) per row
pcount(a, b, c, value = TRUE)

## -----------------------------------------------------------------------------
dates <- as.Date(c("2024-01-01", "2024-01-02", "2024-01-03"))

# Base ifelse strips class
class(ifelse(dates > "2024-01-01", dates, dates - 1))

# iif preserves class
class(iif(dates > "2024-01-01", dates, dates - 1))

## -----------------------------------------------------------------------------
x <- c(-2, -1, NA, 1, 2)
iif(x > 0, "positive", "non-positive", na = "missing")

## -----------------------------------------------------------------------------
score <- c(95, 82, 67, 45, 78)

nif(
  score >= 90, "A",
  score >= 80, "B", 
  score >= 70, "C",
  score >= 60, "D",
  default = "F"
)

## -----------------------------------------------------------------------------
status_code <- c(1L, 2L, 3L, 1L, 4L)

vswitch(
  x = status_code,
  values = c(1L, 2L, 3L),
  outputs = c("pending", "approved", "rejected"),
  default = "unknown"
)

## -----------------------------------------------------------------------------
nswitch(status_code,
  1L, "pending",
  2L, "approved", 
  3L, "rejected",
  default = "unknown"
)

## -----------------------------------------------------------------------------
df <- data.frame(
  code = c(1, 2, 1, 3, 2),
  val_a = c(10, 20, 30, 40, 50),
  val_b = c(100, 200, 300, 400, 500)
)
with(df, nswitch(code,
  1, val_a,
  2, val_b,
  3, 0,
  default = NA_real_
))

## -----------------------------------------------------------------------------
vec <- c("a", "b", "a", "c", "b")

# Get unique values
funique(vec)

# Check for duplicates
fduplicated(vec)

## -----------------------------------------------------------------------------
df <- data.frame(
  x = c(1, 1, 2, 2),
  y = c("a", "a", "b", "b")
)
uniqLen(df)
funique(df)

## -----------------------------------------------------------------------------
countOccur(c("apple", "banana", "apple", "cherry"))

## -----------------------------------------------------------------------------
set.seed(42)
x <- rnorm(1000)

# Get indices of top 5 values
topn(x, n = 5)

# Get the actual values (decreasing = FALSE for bottom values)
topn(x, n = 5, decreasing = FALSE, index = FALSE)

## -----------------------------------------------------------------------------
charToFact(c("a", "b", NA, "a"))

## -----------------------------------------------------------------------------
haystack <- c(1, 2, 3, 4, 1, 2, 5)
needle <- c(1, 2)

fpos(needle, haystack)

