/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.common.util.iterators.IntervalIntDomainIterator;
import choco.cp.solver.variables.delta.IntervalDeltaDomain;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import java.util.Random;

public class IntervalIntDomain
extends AbstractIntDomain {
    private static final int eventBitMask = 7;
    private static Random random = new Random(System.currentTimeMillis());
    private final IStateInt inf;
    private final IStateInt sup;
    protected IntervalIntDomainIterator _iterator = null;

    public IntervalIntDomain(IntDomainVarImpl v, int a, int b, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        this.inf = environment.makeInt(a);
        this.sup = environment.makeInt(b);
        this.deltaDom = new IntervalDeltaDomain(this, a, b);
    }

    @Override
    public boolean contains(int x) {
        return x >= this.getInf() && x <= this.getSup();
    }

    @Override
    public int getNextValue(int x) {
        if (x < this.getInf()) {
            return this.getInf();
        }
        if (x < this.getSup()) {
            return x + 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final int fastNextValue(int x) {
        return x + 1;
    }

    @Override
    public int getPrevValue(int x) {
        if (x > this.getSup()) {
            return this.getSup();
        }
        if (x > this.getInf()) {
            return x - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getRandomValue() {
        int inf = this.getInf();
        int rand = random.nextInt(this.getSize());
        return inf + rand;
    }

    @Override
    public final int getSize() {
        return this.getSup() - this.getInf() + 1;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new IntervalIntDomainIterator();
        } else if (!this._iterator.reusable()) {
            this._iterator = new IntervalIntDomainIterator();
        }
        this._iterator.init(this);
        return this._iterator;
    }

    @Override
    public boolean remove(int x) {
        return false;
    }

    @Override
    public final int getSup() {
        return this.sup.get();
    }

    @Override
    public final int getInf() {
        return this.inf.get();
    }

    @Override
    public void restrict(int x) {
        if ((this.variable.getEvent().getPropagatedEvents() & 7) != 0) {
            this.deltaDom.remove(x);
        }
        this.inf.set(x);
        this.sup.set(x);
    }

    @Override
    public int updateInf(int x) {
        if ((this.variable.getEvent().getPropagatedEvents() & 7) != 0) {
            this.deltaDom.remove(x);
        }
        this.inf.set(x);
        return x;
    }

    @Override
    public int updateSup(int x) {
        if ((this.variable.getEvent().getPropagatedEvents() & 7) != 0) {
            this.deltaDom.remove(x);
        }
        this.sup.set(x);
        return x;
    }

    @Override
    protected boolean _removeVal(int x, SConstraint cause) throws ContradictionException {
        int infv = this.getInf();
        int supv = this.getSup();
        if (x == infv) {
            this._updateInf(x + 1, cause);
            if (this.getInf() == supv) {
                this._instantiate(supv, cause);
            }
            return true;
        }
        if (x == supv) {
            this._updateSup(x - 1, cause);
            if (this.getSup() == infv) {
                this._instantiate(infv, cause);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnumerated() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String pretty() {
        StringBuilder ret = new StringBuilder(32);
        ret.append('[').append(this.getInf()).append(" .. ").append(this.getSup()).append(']');
        return ret.toString();
    }

    @Override
    public void freezeDeltaDomain() {
        if ((this.variable.getEvent().getPropagatedEvents() & 7) != 0) {
            this.deltaDom.freeze();
        }
    }

    @Override
    public boolean releaseDeltaDomain() {
        return (this.variable.getEvent().getPropagatedEvents() & 7) == 0 || this.deltaDom.release();
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return (this.variable.getEvent().getPropagatedEvents() & 7) == 0 || this.deltaDom.isReleased();
    }
}

