/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.jul;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.jul.JDK14LoggerAdapter;

public class JDK14LoggerFactory
implements ILoggerFactory {
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    private static String JUL_ROOT_LOGGER_NAME = "";

    public JDK14LoggerFactory() {
        java.util.logging.Logger.getLogger("");
    }

    public Logger getLogger(String name) {
        Logger slf4jLogger;
        if (name.equalsIgnoreCase("ROOT")) {
            name = JUL_ROOT_LOGGER_NAME;
        }
        if ((slf4jLogger = (Logger)this.loggerMap.get(name)) != null) {
            return slf4jLogger;
        }
        java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger(name);
        JDK14LoggerAdapter newInstance = new JDK14LoggerAdapter(julLogger);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }
}

