/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.HashMap;
import java.util.Map;

public class Borders {
    private boolean border = false;
    private String borderProperties = null;
    private boolean borderTop = false;
    private String borderTopProperties = null;
    private boolean borderBottom = false;
    private String borderBottomProperties = null;
    private boolean borderLeft = false;
    private String borderLeftProperties = null;
    private boolean borderRight = false;
    private String borderRightProperties = null;
    private static final String DEFAULT_BORDER_PROPERTIES = "0.035cm solid #000000";

    public Borders() {
    }

    public Borders(boolean border) {
        this.border = border;
    }

    public Borders(boolean border, String borderProperties) {
        this.border = border;
        this.borderProperties = borderProperties;
    }

    public Borders(boolean borderTop, boolean borderBottom, boolean borderLeft, boolean borderRight) {
        this.borderTop = borderTop;
        this.borderBottom = borderBottom;
        this.borderLeft = borderLeft;
        this.borderRight = borderRight;
    }

    public Borders(boolean borderTop, String borderTopProperties, boolean borderBottom, String borderBottomProperties, boolean borderLeft, String borderLeftProperties, boolean borderRight, String borderRightProperties) {
        this.borderTop = borderTop;
        this.borderTopProperties = borderTopProperties;
        this.borderBottom = borderBottom;
        this.borderBottomProperties = borderBottomProperties;
        this.borderLeft = borderLeft;
        this.borderLeftProperties = borderLeftProperties;
        this.borderRight = borderRight;
        this.borderRightProperties = borderRightProperties;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public String getBorderProperties() {
        return this.borderProperties == null ? DEFAULT_BORDER_PROPERTIES : this.borderProperties;
    }

    public void setBorderProperties(String borderProperties) {
        this.borderProperties = borderProperties;
    }

    public boolean isBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(boolean borderTop) {
        this.borderTop = borderTop;
    }

    public String getBorderTopProperties() {
        return this.borderTopProperties == null ? DEFAULT_BORDER_PROPERTIES : this.borderTopProperties;
    }

    public void setBorderTopProperties(String borderTopProperties) {
        this.borderTopProperties = borderTopProperties;
    }

    public boolean isBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(boolean borderBottom) {
        this.borderBottom = borderBottom;
    }

    public String getBorderBottomProperties() {
        return this.borderBottomProperties == null ? DEFAULT_BORDER_PROPERTIES : this.borderBottomProperties;
    }

    public void setBorderBottomProperties(String borderBottomProperties) {
        this.borderBottomProperties = borderBottomProperties;
    }

    public boolean isBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(boolean borderLeft) {
        this.borderLeft = borderLeft;
    }

    public String getBorderLeftProperties() {
        return this.borderLeftProperties == null ? DEFAULT_BORDER_PROPERTIES : this.borderLeftProperties;
    }

    public void setBorderLeftProperties(String borderLeftProperties) {
        this.borderLeftProperties = borderLeftProperties;
    }

    public boolean isBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(boolean borderRight) {
        this.borderRight = borderRight;
    }

    public String getBorderRightProperties() {
        return this.borderRightProperties == null ? DEFAULT_BORDER_PROPERTIES : this.borderRightProperties;
    }

    public void setBorderRightProperties(String borderRightProperties) {
        this.borderRightProperties = borderRightProperties;
    }

    public boolean anyBorder() {
        return this.border || this.borderTop || this.borderBottom || this.borderLeft || this.borderRight;
    }

    public Map<String, String> getCssStyles() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.isBorder()) {
            result.put("border", this.getBorderProperties());
        }
        if (this.isBorderTop()) {
            result.put("border-top", this.getBorderTopProperties());
        }
        if (this.isBorderBottom()) {
            result.put("border-bottom", this.getBorderBottomProperties());
        }
        if (this.isBorderLeft()) {
            result.put("border-left", this.getBorderLeftProperties());
        }
        if (this.isBorderRight()) {
            result.put("border-right", this.getBorderRightProperties());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.border ? 1 : 0);
        result = 31 * result + (this.borderBottom ? 1 : 0);
        result = 31 * result + (this.borderBottomProperties == null ? 0 : this.borderBottomProperties.hashCode());
        result = 31 * result + (this.borderLeft ? 1 : 0);
        result = 31 * result + (this.borderLeftProperties == null ? 0 : this.borderLeftProperties.hashCode());
        result = 31 * result + (this.borderProperties == null ? 0 : this.borderProperties.hashCode());
        result = 31 * result + (this.borderRight ? 1 : 0);
        result = 31 * result + (this.borderRightProperties == null ? 0 : this.borderRightProperties.hashCode());
        result = 31 * result + (this.borderTop ? 1 : 0);
        result = 31 * result + (this.borderTopProperties == null ? 0 : this.borderTopProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Borders other = (Borders)obj;
        if (this.border != other.border) {
            return false;
        }
        if (this.borderProperties == null ? other.borderProperties != null : !this.borderProperties.equals(other.borderProperties)) {
            return false;
        }
        if (this.borderBottom != other.borderBottom) {
            return false;
        }
        if (this.borderBottomProperties == null ? other.borderBottomProperties != null : !this.borderBottomProperties.equals(other.borderBottomProperties)) {
            return false;
        }
        if (this.borderLeft != other.borderLeft) {
            return false;
        }
        if (this.borderLeftProperties == null ? other.borderLeftProperties != null : !this.borderLeftProperties.equals(other.borderLeftProperties)) {
            return false;
        }
        if (this.borderRight != other.borderRight) {
            return false;
        }
        if (this.borderRightProperties == null ? other.borderRightProperties != null : !this.borderRightProperties.equals(other.borderRightProperties)) {
            return false;
        }
        if (this.borderTop != other.borderTop) {
            return false;
        }
        return !(this.borderTopProperties == null ? other.borderTopProperties != null : !this.borderTopProperties.equals(other.borderTopProperties));
    }
}

