/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsUnit;

public enum RegularFrequency {
    Undefined(0),
    Yearly(1),
    HalfYearly(2),
    QuadriMonthly(3),
    Quarterly(4),
    BiMonthly(6),
    Monthly(12);

    private static final RegularFrequency[] ENUMS;
    private final int value;

    public static RegularFrequency parse(int value) throws IllegalArgumentException {
        if (value <= 0) {
            return Undefined;
        }
        if (12 % value == 0) {
            for (int i = 0; i < ENUMS.length; ++i) {
                if (value != RegularFrequency.ENUMS[i].value) continue;
                return ENUMS[i];
            }
        }
        throw new IllegalArgumentException("Cannot parse " + value);
    }

    public static final RegularFrequency[] all() {
        return (RegularFrequency[])ENUMS.clone();
    }

    private RegularFrequency(int value) {
        this.value = value;
    }

    public int toInt() {
        return this.value;
    }

    public boolean contains(RegularFrequency hfreq) {
        return hfreq.value > this.value && hfreq.value % this.value == 0;
    }

    public int ratio(RegularFrequency lfreq) {
        if (this.value % lfreq.value != 0) {
            throw new TsException("Incompatible frequencies");
        }
        return this.value / lfreq.value;
    }

    public TsUnit toTsUnit() {
        switch (this.ordinal()) {
            case 1: {
                return TsUnit.P1Y;
            }
            case 2: {
                return TsUnit.P6M;
            }
            case 3: {
                return TsUnit.P4M;
            }
            case 4: {
                return TsUnit.P3M;
            }
            case 5: {
                return TsUnit.P2M;
            }
            case 6: {
                return TsUnit.P1M;
            }
            case 0: {
                return TsUnit.UNDEFINED;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    public static RegularFrequency parseTsUnit(TsUnit unit) throws IllegalArgumentException {
        if (unit.equals(TsUnit.UNDEFINED)) {
            return Undefined;
        }
        switch (unit.getChronoUnit()) {
            case YEARS: {
                if (unit.getAmount() != 1L) break;
                return Yearly;
            }
            case MONTHS: {
                if (unit.getAmount() == 6L) {
                    return HalfYearly;
                }
                if (unit.getAmount() == 4L) {
                    return QuadriMonthly;
                }
                if (unit.getAmount() == 3L) {
                    return Quarterly;
                }
                if (unit.getAmount() == 2L) {
                    return BiMonthly;
                }
                if (unit.getAmount() != 1L) break;
                return Monthly;
            }
        }
        throw new IllegalArgumentException("Unsupported unit " + String.valueOf(unit));
    }

    static {
        ENUMS = RegularFrequency.values();
    }
}

