/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import java.util.function.DoublePredicate;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.CPointer;
import jdplus.toolkit.base.core.math.matrices.RPointer;

public abstract class DataPointer {
    final double[] p;
    int pos;

    public static DataPointer of(double[] storage, int pos) {
        return new CPointer(storage, pos);
    }

    public static DataPointer of(double[] storage, int pos, int inc) {
        if (inc == 1) {
            return new CPointer(storage, pos);
        }
        return new RPointer(storage, pos, inc);
    }

    public static DataPointer of(DataBlock z) {
        return DataPointer.of(z.getStorage(), z.getStartPosition(), z.getIncrement());
    }

    protected DataPointer(double[] storage, int pos) {
        this.p = storage;
        this.pos = pos;
    }

    public abstract int inc();

    public final double[] p() {
        return this.p;
    }

    public final int pos() {
        return this.pos;
    }

    public final void pos(int npos) {
        this.pos = npos;
    }

    public final void move(int del) {
        this.pos += del;
    }

    public final void next() {
        ++this.pos;
    }

    public final void previous() {
        --this.pos;
    }

    public double value() {
        return this.p[this.pos];
    }

    public void value(double nval) {
        this.p[this.pos] = nval;
    }

    public abstract double value(int var1);

    public double fastNorm2(int n) {
        return Math.sqrt(this.ssq(n));
    }

    public double norm2(int n) {
        int inc = this.inc();
        if (n < 1) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(this.p[this.pos]);
        }
        int imax = this.pos + n * inc;
        double scale = 0.0;
        double ssq = 1.0;
        for (int i = this.pos; i < imax; i += inc) {
            double tmp;
            double xcur = this.p[i];
            if (xcur == 0.0) continue;
            double absxi = Math.abs(xcur);
            if (scale < absxi) {
                tmp = scale / absxi;
                ssq = 1.0 + ssq * tmp * tmp;
                scale = absxi;
                continue;
            }
            tmp = absxi / scale;
            ssq += tmp * tmp;
        }
        return scale * Math.sqrt(ssq);
    }

    public abstract boolean test(int var1, DoublePredicate var2);

    public abstract void mul(int var1, double var2);

    public abstract void div(int var1, double var2);

    public abstract void add(int var1, double var2);

    public abstract void set(int var1, double var2);

    public abstract void chs(int var1);

    public abstract double sum(int var1);

    public abstract double asum(int var1);

    public abstract double ssq(int var1);

    public abstract double dot(int var1, DataPointer var2);

    public abstract void addAX(int var1, double var2, DataPointer var4);
}

