/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.ParametersEstimation;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.MissingValueEstimation;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class LightweightLinearModel {
    @Generated
    private LightweightLinearModel() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Estimation
    implements GeneralLinearModel.Estimation {
        @NonNull
        private final TsDomain domain;
        @NonNull
        private final DoubleSeq y;
        @NonNull
        private final Matrix X;
        @NonNull
        private final DoubleSeq coefficients;
        @NonNull
        private final Matrix coefficientsCovariance;
        @NonNull
        private final MissingValueEstimation[] missing;
        @NonNull
        private final ParametersEstimation parameters;
        private final LikelihoodStatistics statistics;
        private final List<ProcessingLog.Information> logs;
        private static final MissingValueEstimation[] NOMISSING = new MissingValueEstimation[0];

        public static Builder builder() {
            Builder builder = new Builder();
            builder.y = DoubleSeq.empty();
            builder.X = Matrix.empty();
            builder.coefficients = DoubleSeq.empty();
            builder.coefficientsCovariance = Matrix.empty();
            builder.missing = NOMISSING;
            builder.parameters = ParametersEstimation.empty();
            return builder;
        }

        @Generated
        Estimation(@NonNull TsDomain domain, @NonNull DoubleSeq y, @NonNull Matrix X, @NonNull DoubleSeq coefficients, @NonNull Matrix coefficientsCovariance, @NonNull MissingValueEstimation[] missing, @NonNull ParametersEstimation parameters, LikelihoodStatistics statistics, List<ProcessingLog.Information> logs) {
            if (domain == null) {
                throw new NullPointerException("domain is marked non-null but is null");
            }
            if (y == null) {
                throw new NullPointerException("y is marked non-null but is null");
            }
            if (X == null) {
                throw new NullPointerException("X is marked non-null but is null");
            }
            if (coefficients == null) {
                throw new NullPointerException("coefficients is marked non-null but is null");
            }
            if (coefficientsCovariance == null) {
                throw new NullPointerException("coefficientsCovariance is marked non-null but is null");
            }
            if (missing == null) {
                throw new NullPointerException("missing is marked non-null but is null");
            }
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.domain = domain;
            this.y = y;
            this.X = X;
            this.coefficients = coefficients;
            this.coefficientsCovariance = coefficientsCovariance;
            this.missing = missing;
            this.parameters = parameters;
            this.statistics = statistics;
            this.logs = logs;
        }

        @Override
        @NonNull
        @Generated
        public TsDomain getDomain() {
            return this.domain;
        }

        @Override
        @NonNull
        @Generated
        public DoubleSeq getY() {
            return this.y;
        }

        @Override
        @NonNull
        @Generated
        public Matrix getX() {
            return this.X;
        }

        @Override
        @NonNull
        @Generated
        public DoubleSeq getCoefficients() {
            return this.coefficients;
        }

        @Override
        @NonNull
        @Generated
        public Matrix getCoefficientsCovariance() {
            return this.coefficientsCovariance;
        }

        @Override
        @NonNull
        @Generated
        public MissingValueEstimation[] getMissing() {
            return this.missing;
        }

        @Override
        @NonNull
        @Generated
        public ParametersEstimation getParameters() {
            return this.parameters;
        }

        @Override
        @Generated
        public LikelihoodStatistics getStatistics() {
            return this.statistics;
        }

        @Override
        @Generated
        public List<ProcessingLog.Information> getLogs() {
            return this.logs;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Estimation)) {
                return false;
            }
            Estimation other = (Estimation)o;
            TsDomain this$domain = this.getDomain();
            TsDomain other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            DoubleSeq this$y = this.getY();
            DoubleSeq other$y = other.getY();
            if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
                return false;
            }
            Matrix this$X = this.getX();
            Matrix other$X = other.getX();
            if (this$X == null ? other$X != null : !this$X.equals(other$X)) {
                return false;
            }
            DoubleSeq this$coefficients = this.getCoefficients();
            DoubleSeq other$coefficients = other.getCoefficients();
            if (this$coefficients == null ? other$coefficients != null : !this$coefficients.equals(other$coefficients)) {
                return false;
            }
            Matrix this$coefficientsCovariance = this.getCoefficientsCovariance();
            Matrix other$coefficientsCovariance = other.getCoefficientsCovariance();
            if (this$coefficientsCovariance == null ? other$coefficientsCovariance != null : !this$coefficientsCovariance.equals(other$coefficientsCovariance)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getMissing(), other.getMissing())) {
                return false;
            }
            ParametersEstimation this$parameters = this.getParameters();
            ParametersEstimation other$parameters = other.getParameters();
            if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
                return false;
            }
            LikelihoodStatistics this$statistics = this.getStatistics();
            LikelihoodStatistics other$statistics = other.getStatistics();
            if (this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics)) {
                return false;
            }
            List<ProcessingLog.Information> this$logs = this.getLogs();
            List<ProcessingLog.Information> other$logs = other.getLogs();
            return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TsDomain $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            DoubleSeq $y = this.getY();
            result = result * 59 + ($y == null ? 43 : $y.hashCode());
            Matrix $X = this.getX();
            result = result * 59 + ($X == null ? 43 : $X.hashCode());
            DoubleSeq $coefficients = this.getCoefficients();
            result = result * 59 + ($coefficients == null ? 43 : $coefficients.hashCode());
            Matrix $coefficientsCovariance = this.getCoefficientsCovariance();
            result = result * 59 + ($coefficientsCovariance == null ? 43 : $coefficientsCovariance.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getMissing());
            ParametersEstimation $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
            LikelihoodStatistics $statistics = this.getStatistics();
            result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
            List<ProcessingLog.Information> $logs = this.getLogs();
            result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "LightweightLinearModel.Estimation(domain=" + String.valueOf(this.getDomain()) + ", y=" + String.valueOf(this.getY()) + ", X=" + String.valueOf(this.getX()) + ", coefficients=" + String.valueOf(this.getCoefficients()) + ", coefficientsCovariance=" + String.valueOf(this.getCoefficientsCovariance()) + ", missing=" + Arrays.deepToString(this.getMissing()) + ", parameters=" + String.valueOf(this.getParameters()) + ", statistics=" + String.valueOf(this.getStatistics()) + ", logs=" + String.valueOf(this.getLogs()) + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private TsDomain domain;
            @Generated
            private DoubleSeq y;
            @Generated
            private Matrix X;
            @Generated
            private DoubleSeq coefficients;
            @Generated
            private Matrix coefficientsCovariance;
            @Generated
            private MissingValueEstimation[] missing;
            @Generated
            private ParametersEstimation parameters;
            @Generated
            private LikelihoodStatistics statistics;
            @Generated
            private ArrayList<ProcessingLog.Information> logs;

            @Generated
            Builder() {
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder domain(@NonNull TsDomain domain) {
                if (domain == null) {
                    throw new NullPointerException("domain is marked non-null but is null");
                }
                this.domain = domain;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder y(@NonNull DoubleSeq y) {
                if (y == null) {
                    throw new NullPointerException("y is marked non-null but is null");
                }
                this.y = y;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder X(@NonNull Matrix X) {
                if (X == null) {
                    throw new NullPointerException("X is marked non-null but is null");
                }
                this.X = X;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder coefficients(@NonNull DoubleSeq coefficients) {
                if (coefficients == null) {
                    throw new NullPointerException("coefficients is marked non-null but is null");
                }
                this.coefficients = coefficients;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder coefficientsCovariance(@NonNull Matrix coefficientsCovariance) {
                if (coefficientsCovariance == null) {
                    throw new NullPointerException("coefficientsCovariance is marked non-null but is null");
                }
                this.coefficientsCovariance = coefficientsCovariance;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder missing(@NonNull MissingValueEstimation[] missing) {
                if (missing == null) {
                    throw new NullPointerException("missing is marked non-null but is null");
                }
                this.missing = missing;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder parameters(@NonNull ParametersEstimation parameters) {
                if (parameters == null) {
                    throw new NullPointerException("parameters is marked non-null but is null");
                }
                this.parameters = parameters;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder statistics(LikelihoodStatistics statistics) {
                this.statistics = statistics;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder log(ProcessingLog.Information log) {
                if (this.logs == null) {
                    this.logs = new ArrayList();
                }
                this.logs.add(log);
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder logs(@org.jspecify.annotations.NonNull Collection<? extends // Could not load outer class - annotation placement on inner may be incorrect
            ProcessingLog.Information> logs) {
                if (logs == null) {
                    throw new NullPointerException("logs cannot be null");
                }
                if (this.logs == null) {
                    this.logs = new ArrayList();
                }
                this.logs.addAll(logs);
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder clearLogs() {
                if (this.logs != null) {
                    this.logs.clear();
                }
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Estimation build() {
                return new Estimation(this.domain, this.y, this.X, this.coefficients, this.coefficientsCovariance, this.missing, this.parameters, this.statistics, switch (this.logs == null ? 0 : this.logs.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.logs.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProcessingLog.Information>(this.logs));
                });
            }

            @Generated
            public @org.jspecify.annotations.NonNull String toString() {
                return "LightweightLinearModel.Estimation.Builder(domain=" + String.valueOf(this.domain) + ", y=" + String.valueOf(this.y) + ", X=" + String.valueOf(this.X) + ", coefficients=" + String.valueOf(this.coefficients) + ", coefficientsCovariance=" + String.valueOf(this.coefficientsCovariance) + ", missing=" + Arrays.deepToString(this.missing) + ", parameters=" + String.valueOf(this.parameters) + ", statistics=" + String.valueOf(this.statistics) + ", logs=" + String.valueOf(this.logs) + ")";
            }
        }
    }

    public static final class Description<M>
    implements GeneralLinearModel.Description<M> {
        private final TsData series;
        private final boolean logTransformation;
        private final LengthOfPeriodType lengthOfPeriodTransformation;
        private final Variable[] variables;
        private final M stochasticComponent;

        @Generated
        Description(TsData series, boolean logTransformation, LengthOfPeriodType lengthOfPeriodTransformation, Variable[] variables, M stochasticComponent) {
            this.series = series;
            this.logTransformation = logTransformation;
            this.lengthOfPeriodTransformation = lengthOfPeriodTransformation;
            this.variables = variables;
            this.stochasticComponent = stochasticComponent;
        }

        @Generated
        public static <M> @org.jspecify.annotations.NonNull Builder<M> builder() {
            return new Builder();
        }

        @Override
        @Generated
        public TsData getSeries() {
            return this.series;
        }

        @Override
        @Generated
        public boolean isLogTransformation() {
            return this.logTransformation;
        }

        @Override
        @Generated
        public LengthOfPeriodType getLengthOfPeriodTransformation() {
            return this.lengthOfPeriodTransformation;
        }

        @Override
        @Generated
        public Variable[] getVariables() {
            return this.variables;
        }

        @Override
        @Generated
        public M getStochasticComponent() {
            return this.stochasticComponent;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description other = (Description)o;
            if (this.isLogTransformation() != other.isLogTransformation()) {
                return false;
            }
            TsData this$series = this.getSeries();
            TsData other$series = other.getSeries();
            if (this$series == null ? other$series != null : !this$series.equals(other$series)) {
                return false;
            }
            LengthOfPeriodType this$lengthOfPeriodTransformation = this.getLengthOfPeriodTransformation();
            LengthOfPeriodType other$lengthOfPeriodTransformation = other.getLengthOfPeriodTransformation();
            if (this$lengthOfPeriodTransformation == null ? other$lengthOfPeriodTransformation != null : !this$lengthOfPeriodTransformation.equals(other$lengthOfPeriodTransformation)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getVariables(), other.getVariables())) {
                return false;
            }
            M this$stochasticComponent = this.getStochasticComponent();
            M other$stochasticComponent = other.getStochasticComponent();
            return !(this$stochasticComponent == null ? other$stochasticComponent != null : !this$stochasticComponent.equals(other$stochasticComponent));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLogTransformation() ? 79 : 97);
            TsData $series = this.getSeries();
            result = result * 59 + ($series == null ? 43 : $series.hashCode());
            LengthOfPeriodType $lengthOfPeriodTransformation = this.getLengthOfPeriodTransformation();
            result = result * 59 + ($lengthOfPeriodTransformation == null ? 43 : $lengthOfPeriodTransformation.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getVariables());
            M $stochasticComponent = this.getStochasticComponent();
            result = result * 59 + ($stochasticComponent == null ? 43 : $stochasticComponent.hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "LightweightLinearModel.Description(series=" + String.valueOf(this.getSeries()) + ", logTransformation=" + this.isLogTransformation() + ", lengthOfPeriodTransformation=" + String.valueOf(this.getLengthOfPeriodTransformation()) + ", variables=" + Arrays.deepToString(this.getVariables()) + ", stochasticComponent=" + String.valueOf(this.getStochasticComponent()) + ")";
        }

        @Generated
        public static class Builder<M> {
            @Generated
            private TsData series;
            @Generated
            private boolean logTransformation;
            @Generated
            private LengthOfPeriodType lengthOfPeriodTransformation;
            @Generated
            private Variable[] variables;
            @Generated
            private M stochasticComponent;

            @Generated
            Builder() {
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<M> series(TsData series) {
                this.series = series;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<M> logTransformation(boolean logTransformation) {
                this.logTransformation = logTransformation;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<M> lengthOfPeriodTransformation(LengthOfPeriodType lengthOfPeriodTransformation) {
                this.lengthOfPeriodTransformation = lengthOfPeriodTransformation;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<M> variables(Variable[] variables) {
                this.variables = variables;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<M> stochasticComponent(M stochasticComponent) {
                this.stochasticComponent = stochasticComponent;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Description<M> build() {
                return new Description<M>(this.series, this.logTransformation, this.lengthOfPeriodTransformation, this.variables, this.stochasticComponent);
            }

            @Generated
            public @org.jspecify.annotations.NonNull String toString() {
                return "LightweightLinearModel.Description.Builder(series=" + String.valueOf(this.series) + ", logTransformation=" + this.logTransformation + ", lengthOfPeriodTransformation=" + String.valueOf(this.lengthOfPeriodTransformation) + ", variables=" + Arrays.deepToString(this.variables) + ", stochasticComponent=" + String.valueOf(this.stochasticComponent) + ")";
            }
        }
    }
}

