/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.DiagnosticsFactory;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnostics;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.tests.OneStepAheadForecastingTest;
import lombok.NonNull;

public class OutOfSampleDiagnosticsFactory<R>
implements DiagnosticsFactory<OutOfSampleDiagnosticsConfiguration, R> {
    public static final String MEAN = "mean";
    public static final String MSE = "mse";
    public static final String NAME = "Out-of-sample";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("mean", "mse"));
    private final OutOfSampleDiagnosticsConfiguration config;
    protected final Function<R, OneStepAheadForecastingTest> extractor;

    public OutOfSampleDiagnosticsFactory(@NonNull OutOfSampleDiagnosticsConfiguration config, Function<R, OneStepAheadForecastingTest> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public OutOfSampleDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public OutOfSampleDiagnosticsFactory<R> with(OutOfSampleDiagnosticsConfiguration config) {
        return new OutOfSampleDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return OutOfSampleDiagnostics.create(this.config, this.extractor.apply(rslts));
    }
}

