/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.outlier;

import internal.toolkit.base.core.arima.AnsleyFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.arima.estimation.ResidualsComputer;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;

public class FastOutlierDetector2<T extends IArimaModel>
extends SingleOutlierDetector<T> {
    private final ArmaFilter filter;
    private final ResidualsComputer resComputer;
    private FastMatrix U;
    private FastMatrix Xl;
    private int[] pivot;
    private double[] yl;
    private double[] b;
    private double[] z;
    private int n;
    private double mad;

    public FastOutlierDetector2(RobustStandardDeviationComputer computer, ArmaFilter filter, ResidualsComputer res) {
        super(computer == null ? RobustStandardDeviationComputer.mad() : computer);
        this.filter = filter == null ? new AnsleyFilter() : filter;
        this.resComputer = res == null ? ResidualsComputer.defaultComputer(this.filter) : res;
    }

    @Override
    protected boolean calc() {
        try {
            if (this.getOutlierFactoriesCount() == 0 || this.ubound <= this.lbound) {
                return false;
            }
            RegArmaModel dmodel = this.getRegArima().differencedModel();
            this.n = this.filter.prepare((IArimaModel)dmodel.getArma(), dmodel.getY().length());
            if (!this.initialize(dmodel)) {
                return false;
            }
            for (int i = 0; i < this.getOutlierFactoriesCount(); ++i) {
                this.processOutlier(i);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    protected boolean initialize(RegArmaModel<T> model) {
        try {
            this.yl = new double[this.n];
            DataBlock Yl = DataBlock.of(this.yl);
            this.filter.apply(model.getY(), Yl);
            FastMatrix regs = model.getX();
            if (regs.isEmpty()) {
                this.mad = this.getStandardDeviationComputer().compute(this.filter(model.getY()));
                return true;
            }
            this.Xl = FastMatrix.make(this.n, regs.getColumnsCount());
            DataBlockIterator rcols = regs.columnsIterator();
            DataBlockIterator drcols = this.Xl.columnsIterator();
            while (rcols.hasNext()) {
                this.filter.apply((DoubleSeq)rcols.next(), drcols.next());
            }
            QRLeastSquaresSolution ls = QRLeastSquaresSolver.robustLeastSquares((DoubleSeq)Yl, this.Xl);
            if (ls.rank() != regs.getColumnsCount()) {
                return false;
            }
            this.pivot = ls.pivot();
            this.U = ls.rawR();
            int nx = this.Xl.getColumnsCount();
            this.z = new double[nx];
            for (int i = 0; i < nx; ++i) {
                this.z[i] = Yl.dot(this.Xl.column(this.pivot[i]));
            }
            UpperTriangularMatrix.solvexU(this.U, DataBlock.of(this.z));
            DoubleSeq B = ls.getB();
            this.b = B.toArray();
            DataBlock e = DataBlock.of(model.getY());
            DoubleSeqCursor coeff = ls.getB().cursor();
            rcols.begin();
            while (rcols.hasNext()) {
                e.addAY(-coeff.getAndNext(), rcols.next());
            }
            this.mad = this.getStandardDeviationComputer().compute(this.filter((DoubleSeq)e));
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    protected void processOutlier(int idx) {
        int i;
        RegArimaModel regArima = this.getRegArima();
        int len = regArima.getY().length();
        BackFilter df = regArima.arima().getNonStationaryAr();
        int d = df.getDegree();
        IOutlierFactory.FilterRepresentation representation = this.getOutlierFactory(idx).getFilterRepresentation();
        if (representation == null) {
            return;
        }
        Object model = this.getRegArima().arima();
        RationalBackFilter pi = model.getPiWeights();
        double[] o = pi.times(representation.filter).getWeights(len);
        double corr = 0.0;
        if (d == 0 && representation.correction != 0.0) {
            Polynomial ar = model.getAr().asPolynomial();
            Polynomial ma = model.getMa().asPolynomial();
            corr = representation.correction * ar.evaluateAt(1.0) / ma.evaluateAt(1.0);
            i = 0;
            while (i < 2 * this.n) {
                int n = i++;
                o[n] = o[n] + corr;
            }
        }
        DataBlock Yl = DataBlock.of(this.yl);
        int nx = this.Xl == null ? 0 : this.Xl.getColumnsCount();
        for (i = this.lbound; i < this.ubound; ++i) {
            if (this.isAllowed(i, idx)) {
                DataBlock Ylc;
                DataBlock Olc;
                FastMatrix Xlc = null;
                if (i < d) {
                    Olc = DataBlock.of(o, d - i, d - i + this.n, 1);
                    Ylc = Yl;
                    if (nx > 0) {
                        Xlc = this.Xl;
                    }
                } else {
                    Olc = DataBlock.of(o, 0, len - i, 1);
                    Ylc = Yl.drop(i - d, 0);
                    if (nx > 0) {
                        Xlc = this.Xl.extract(i - d, len - i, 0, nx);
                    }
                }
                double xx = Olc.ssq();
                double xy = Olc.dot(Ylc);
                if (this.U != null) {
                    double[] w = new double[this.b.length];
                    for (int q = 0; q < nx; ++q) {
                        w[q] = Olc.dot(Xlc.column(this.pivot[q]));
                    }
                    DataBlock a = DataBlock.of(w);
                    UpperTriangularMatrix.solvexU(this.U, a);
                    double q = a.ssq();
                    double v = xx - q;
                    if (v <= 0.0) {
                        this.exclude(i, idx);
                        continue;
                    }
                    double c = xy - DataBlock.of(this.z).dot(a);
                    this.setT(i, idx, c / (Math.sqrt(v) * this.mad));
                    this.setCoefficient(i, idx, c / v);
                    continue;
                }
                if (xx <= 0.0) {
                    this.exclude(i, idx);
                    this.setT(i, idx, Double.NaN);
                    this.setCoefficient(i, idx, Double.NaN);
                    continue;
                }
                this.setT(i, idx, xy / (Math.sqrt(xx) * this.mad));
                this.setCoefficient(i, idx, xy / xx);
                continue;
            }
            this.setT(i, idx, Double.NaN);
            this.setCoefficient(i, idx, Double.NaN);
        }
    }

    protected DoubleSeq filter(DoubleSeq res) {
        return this.resComputer.residuals((IArimaModel)this.getRegArima().differencedModel().getArma(), res);
    }

    @Override
    protected void clear(boolean all) {
        super.clear(all);
        this.U = null;
        this.Xl = null;
        this.b = null;
        this.z = null;
    }
}

