/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.sarima.estimation;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.FunctionException;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.sarima.SarimaModel;

public class SarimaMapping
implements IArimaMapping<SarimaModel> {
    static final double MAX = 0.99999;
    public static final double STEP = Math.pow(2.220446E-16, 0.5);
    private final SarimaOrders spec;
    private final double eps;
    private final boolean all;
    public static final String PHI = "phi";
    public static final String BPHI = "bphi";
    public static final String TH = "th";
    public static final String BTH = "bth";

    public static boolean checkStability(double d) {
        return Math.abs(d) < 1.0;
    }

    public static boolean checkStability(double a, double b) {
        double ro = b * b - 4.0 * a;
        if (ro < 0.0) {
            return Math.abs(a) < 1.0;
        }
        double sro = Math.sqrt(ro);
        double r = (-b + sro) / (2.0 * a);
        if (Math.abs(1.0 / r) >= 1.0) {
            return false;
        }
        r = (-b - sro) / (2.0 * a);
        return Math.abs(1.0 / r) < 1.0;
    }

    public static boolean checkStability(DoubleSeq c) {
        int nc;
        for (nc = c.length(); nc > 0 && c.get(nc - 1) == 0.0; --nc) {
        }
        if (nc == 0) {
            return true;
        }
        if (nc == 1) {
            return SarimaMapping.checkStability(c.get(0));
        }
        if (nc == 2) {
            return SarimaMapping.checkStability(c.get(1), c.get(0));
        }
        return FilterUtility.checkStability(c.extract(0, nc));
    }

    private static boolean stabilize(boolean all, SarimaOrders spec, DataBlock p) {
        boolean rslt = false;
        int start = 0;
        if (spec.getP() > 0) {
            if (SarimaMapping.stabilize(p.extract(0, spec.getP()))) {
                rslt = true;
            }
            start += spec.getP();
        }
        if (spec.getBp() > 0) {
            if (SarimaMapping.stabilize(p.extract(start, spec.getBp()))) {
                rslt = true;
            }
            start += spec.getBp();
        }
        if (!all) {
            return rslt;
        }
        if (spec.getQ() > 0) {
            if (SarimaMapping.stabilize(p.extract(start, spec.getQ()))) {
                rslt = true;
            }
            start += spec.getQ();
        }
        if (spec.getBq() > 0 && SarimaMapping.stabilize(p.extract(start, spec.getBq()))) {
            rslt = true;
        }
        return rslt;
    }

    private static boolean stabilize(DataBlock c) {
        Polynomial sp;
        int nc = c.length();
        if (nc == 0) {
            return false;
        }
        if (SarimaMapping.checkStability((DoubleSeq)c)) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(0);
            double cabs = Math.abs(c0);
            if (cabs > 1.0) {
                c.set(0, 1.0 / c0);
                return true;
            }
            return false;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        for (int i = 0; i < nc; ++i) {
            ctmp[1 + i] = c.get(i);
        }
        Polynomial p = Polynomial.of(ctmp);
        if (p != (sp = SarimaMapping.stabilize(p))) {
            for (int i = 0; i < nc; ++i) {
                c.set(i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    public static Polynomial stabilize(Polynomial p) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = 1.0 / roots[i].abs();
            if (!(n > 1.0)) continue;
            roots[i] = root.inv();
            changed = true;
        }
        if (!changed) {
            return p;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        return ptmp;
    }

    public static SarimaModel stabilize(SarimaModel m) {
        DataBlock np = DataBlock.of(m.parameters());
        SarimaOrders mspec = m.orders();
        if (SarimaMapping.stabilize(true, mspec, np)) {
            return SarimaModel.builder(mspec).parameters((DoubleSeq)np).build();
        }
        return m;
    }

    public static SarimaMapping of(SarimaOrders spec) {
        return new SarimaMapping(spec, STEP, true);
    }

    public static SarimaMapping ofStationary(SarimaOrders spec) {
        SarimaOrders nspec = spec.clone();
        nspec.setD(0);
        nspec.setBd(0);
        return new SarimaMapping(nspec, STEP, true);
    }

    public SarimaMapping(SarimaOrders spec, double eps, boolean all) {
        this.spec = spec;
        this.all = all;
        this.eps = eps;
    }

    @Override
    public boolean checkBoundaries(DoubleSeq p) {
        int start = 0;
        if (this.spec.getP() > 0) {
            if (!SarimaMapping.checkStability(p.extract(0, this.spec.getP()))) {
                return false;
            }
            start += this.spec.getP();
        }
        if (this.spec.getBp() > 0) {
            if (!SarimaMapping.checkStability(p.extract(start, this.spec.getBp()))) {
                return false;
            }
            start += this.spec.getBp();
        }
        if (this.all) {
            if (this.spec.getQ() > 0) {
                if (!SarimaMapping.checkStability(p.extract(start, this.spec.getQ()))) {
                    return false;
                }
                start += this.spec.getQ();
            }
            if (this.spec.getBq() > 0 && !SarimaMapping.checkStability(p.extract(start, this.spec.getBq()))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        double p = inparams.get(idx);
        if (p < 0.0) {
            return this.eps * Math.max(1.0, -p);
        }
        return -this.eps * Math.max(1.0, p);
    }

    @Override
    public int getDim() {
        return this.spec.getParametersCount();
    }

    public boolean isCheckingAll() {
        return this.all;
    }

    @Override
    public double lbound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBp() > 0) {
            if (idx < this.spec.getBp()) {
                if (this.spec.getBp() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getBp();
        }
        if (this.spec.getQ() > 0 && idx < this.spec.getQ()) {
            if (this.spec.getQ() == 1) {
                return -0.99999;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (this.spec.getBq() == 1) {
            return -0.99999;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public SarimaModel map(DoubleSeq p) {
        if (p.length() != this.spec.getParametersCount()) {
            throw new FunctionException("Incompatible dimensions in the paramerers");
        }
        return SarimaModel.builder(this.spec).parameters(p).build();
    }

    @Override
    public double ubound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBp() > 0) {
            if (idx < this.spec.getBp()) {
                if (this.spec.getBp() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getBp();
        }
        if (this.spec.getQ() > 0 && idx < this.spec.getQ()) {
            if (this.spec.getQ() == 1) {
                return 0.99999;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.spec.getBq() == 1) {
            return 0.99999;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(DataBlock value) {
        if (value.length() != this.spec.getParametersCount()) {
            return ParamValidation.Invalid;
        }
        if (SarimaMapping.stabilize(true, this.spec, value)) {
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    @Override
    public DoubleSeq getDefaultParameters() {
        int i;
        double[] p = new double[this.spec.getParametersCount()];
        int nar = this.spec.getP() + this.spec.getBp();
        for (i = 0; i < nar; ++i) {
            p[i] = -0.1;
        }
        for (i = nar; i < p.length; ++i) {
            p[i] = -0.2;
        }
        return DoubleSeq.of((double[])p);
    }

    @Override
    public DoubleSeq parametersOf(SarimaModel m) {
        return m.parameters();
    }

    @Override
    public String getDescription(int idx) {
        return SarimaMapping.getDescription(this.spec, idx);
    }

    static String getDescription(SarimaOrders xspec, int idx) {
        int i = idx;
        if (i < xspec.getP()) {
            return SarimaMapping.desc(PHI, i);
        }
        if ((i -= xspec.getP()) < xspec.getBp()) {
            return SarimaMapping.desc(BPHI, i);
        }
        if ((i -= xspec.getBp()) < xspec.getQ()) {
            return SarimaMapping.desc(TH, i);
        }
        if ((i -= xspec.getQ()) < xspec.getBq()) {
            return SarimaMapping.desc(BTH, i);
        }
        return "";
    }

    static String desc(String prefix, int idx) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append('(').append(idx + 1).append(')');
        return builder.toString();
    }

    public SarimaOrders getSpec() {
        return this.spec;
    }

    @Override
    public IArimaMapping<SarimaModel> stationaryMapping() {
        if (this.spec.isStationary()) {
            return this;
        }
        return SarimaMapping.ofStationary(this.spec);
    }
}

