/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

public class ExternalEffects
implements ISsfLoading {
    private final ISsfLoading loading;
    private final FastMatrix data;
    private final int nm;
    private final int nx;
    private final DataBlock tmp;

    ExternalEffects(int dim, ISsfLoading loading, FastMatrix data) {
        this.data = data;
        this.loading = loading;
        this.nm = dim;
        this.nx = data.getColumnsCount();
        this.tmp = DataBlock.make(this.nx);
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public void Z(int pos, DataBlock z) {
        DataWindow range = z.window(0, this.nm);
        this.loading.Z(pos, range.get());
        range.next(this.nx).copy(this.data.row(pos));
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        DataWindow range = x.window(0, this.nm);
        double r = this.loading.ZX(pos, range.get());
        return r + range.next(this.nx).dot(this.data.row(pos));
    }

    @Override
    public double ZVZ(int pos, FastMatrix V) {
        MatrixWindow v = V.topLeft(0, 0);
        double v00 = this.loading.ZVZ(pos, v.next(this.nm, this.nm));
        this.tmp.set(0.0);
        double v01 = this.tmp.dot(this.data.row(pos));
        this.loading.ZM(pos, v.vnext(this.nx), this.tmp);
        double v11 = QuadraticForm.apply(v.hnext(this.nx), this.data.row(pos));
        return v00 + 2.0 * v01 + v11;
    }

    @Override
    public void VpZdZ(int pos, FastMatrix V, double d) {
        if (d == 0.0) {
            return;
        }
        MatrixWindow v = V.topLeft(0, 0);
        FastMatrix dv = v.next(this.nm, this.nm);
        this.loading.VpZdZ(pos, dv, d);
        MatrixWindow vtmp = MatrixWindow.of(dv);
        FastMatrix hv = vtmp.hnext(this.nx);
        FastMatrix vv = v.vnext(this.nx);
        DataBlockIterator rows = vv.rowsIterator();
        DataBlock xrow = this.data.row(pos);
        DoubleSeqCursor.OnMutable cell = xrow.cursor();
        while (rows.hasNext()) {
            this.loading.XpZd(pos, rows.next(), d * cell.getAndNext());
        }
        hv.copyTranspose(vv);
        v.hnext(this.nx).addXaXt(d, xrow);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        DataWindow range = x.window(0, this.nm);
        this.loading.XpZd(pos, range.get(), d);
        range.next(this.nx).addAY(d, this.data.row(pos));
    }
}

