/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.dk.BaseDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class FastDkFilter {
    private final VarianceFilterProvider vf;
    private final ISsf ssf;
    private final ISsfLoading loading;
    private final ISsfDynamics dynamics;
    private final int enddiffuse;
    private final boolean normalized;

    public boolean isnormalized() {
        return this.normalized;
    }

    public boolean filter(FastMatrix x) {
        if (x.getColumnsCount() == 1) {
            return new FastDiffuseFilter1().filter(x.column(0), this.normalized);
        }
        return new FastDiffuseFilterN().filter(x, this.normalized);
    }

    public boolean filter(DataBlock x) {
        return new FastDiffuseFilter1().filter(x, this.normalized);
    }

    public FastDkFilter(ISsf ssf, BaseDiffuseFilteringResults frslts, boolean normalized) {
        this.vf = VarianceFilterProvider.of(frslts);
        this.ssf = ssf;
        this.loading = ssf.loading();
        this.dynamics = ssf.dynamics();
        this.enddiffuse = frslts.getEndDiffusePosition();
        this.normalized = normalized;
    }

    public void apply(DoubleSeq in, DataBlock out) {
        new FastDiffuseFilter1().apply(in, out);
    }

    class FastDiffuseFilter1 {
        private DataBlock state;

        FastDiffuseFilter1() {
        }

        boolean filter(DataBlock x, boolean normalized) {
            int len = FastDkFilter.this.vf.size();
            if (x.length() > len) {
                return false;
            }
            int dim = FastDkFilter.this.ssf.getStateDim();
            int n = x.length();
            this.state = DataBlock.make(dim);
            int pos = 0;
            do {
                x.set(pos, this.iterate(pos, x.get(pos), normalized));
            } while (++pos < n);
            return true;
        }

        private double iterate(int i, double y, boolean normalized) {
            DataBlock K;
            double w;
            boolean missing = FastDkFilter.this.vf.isMissing(i);
            double f = FastDkFilter.this.vf.errorVariance(i);
            if (i < FastDkFilter.this.enddiffuse) {
                double fi = FastDkFilter.this.vf.diffuseNorm2(i);
                if (fi != 0.0) {
                    w = fi;
                    K = FastDkFilter.this.vf.Mi(i);
                } else {
                    w = f;
                    K = FastDkFilter.this.vf.M(i);
                }
            } else {
                w = f;
                K = FastDkFilter.this.vf.M(i);
            }
            double e = y - FastDkFilter.this.loading.ZX(i, this.state);
            if (w > 0.0 && !missing) {
                this.state.addAY(e / w, K);
            }
            if (f > 0.0) {
                if (normalized) {
                    e /= Math.sqrt(f);
                }
            } else {
                e = Math.abs(e) > 1.0E-9 ? Double.NaN : 0.0;
            }
            FastDkFilter.this.dynamics.TX(i, this.state);
            return e;
        }

        boolean apply(DoubleSeq in, DataBlock out) {
            int len = FastDkFilter.this.vf.size();
            if (in.length() > len) {
                return false;
            }
            int dim = FastDkFilter.this.ssf.getStateDim();
            int n = in.length();
            this.state = DataBlock.make(dim);
            int pos = 0;
            int opos = 0;
            do {
                boolean missing;
                if (!(missing = FastDkFilter.this.vf.isMissing(pos))) {
                    DataBlock K;
                    double w;
                    double f = FastDkFilter.this.vf.errorVariance(pos);
                    boolean diffuse = false;
                    if (pos < FastDkFilter.this.enddiffuse) {
                        double fi = FastDkFilter.this.vf.diffuseNorm2(pos);
                        if (fi != 0.0) {
                            w = fi;
                            K = FastDkFilter.this.vf.Mi(pos);
                            diffuse = true;
                        } else {
                            w = f;
                            K = FastDkFilter.this.vf.M(pos);
                        }
                    } else {
                        w = f;
                        K = FastDkFilter.this.vf.M(pos);
                    }
                    double e = in.get(pos) - FastDkFilter.this.loading.ZX(pos, this.state);
                    this.state.addAY(e / w, K);
                    if (!diffuse && f != 0.0) {
                        out.set(opos++, e / Math.sqrt(f));
                    }
                }
                FastDkFilter.this.dynamics.TX(pos++, this.state);
            } while (pos < n);
            return true;
        }
    }

    class FastDiffuseFilterN {
        private FastMatrix states;
        private DataBlock tmp;
        private DataBlockIterator scols;

        FastDiffuseFilterN() {
        }

        boolean filter(FastMatrix x, boolean normalized) {
            int n = FastDkFilter.this.vf.size();
            if (x.getRowsCount() > n) {
                return false;
            }
            int dim = FastDkFilter.this.ssf.getStateDim();
            this.states = FastMatrix.make(dim, x.getColumnsCount());
            this.prepareTmp();
            DataBlockIterator rows = x.rowsIterator();
            int pos = 0;
            while (rows.hasNext()) {
                this.iterate(pos++, rows.next(), normalized);
            }
            return true;
        }

        private void prepareTmp() {
            int nvars = this.states.getColumnsCount();
            this.tmp = DataBlock.make(nvars);
            this.scols = this.states.columnsIterator();
        }

        private void iterate(int i, DataBlock row, boolean normalized) {
            DataBlock K;
            double w;
            boolean missing = FastDkFilter.this.vf.isMissing(i);
            double f = FastDkFilter.this.vf.errorVariance(i);
            if (i < FastDkFilter.this.enddiffuse) {
                double fi = FastDkFilter.this.vf.diffuseNorm2(i);
                if (fi != 0.0) {
                    w = fi;
                    K = FastDkFilter.this.vf.Mi(i);
                } else {
                    w = f;
                    K = FastDkFilter.this.vf.M(i);
                }
            } else {
                w = f;
                K = FastDkFilter.this.vf.M(i);
            }
            FastDkFilter.this.loading.ZM(i, this.states, this.tmp);
            row.sub(this.tmp);
            if (w > 0.0 && !missing) {
                this.scols.reset();
                DoubleSeqCursor.OnMutable reader = row.cursor();
                while (this.scols.hasNext()) {
                    DataBlock scol = this.scols.next();
                    scol.addAY(reader.getAndNext() / w, K);
                }
            }
            if (f > 0.0) {
                if (normalized) {
                    row.mul(1.0 / Math.sqrt(f));
                }
            } else {
                row.apply(q -> Math.abs(q) > 1.0E-9 ? Double.NaN : 0.0);
            }
            this.scols.reset();
            while (this.scols.hasNext()) {
                FastDkFilter.this.dynamics.TX(i, this.scols.next());
            }
        }
    }

    public static interface VarianceFilterProvider {
        public int size();

        public int endDiffusePosition();

        public boolean isMissing(int var1);

        public double errorVariance(int var1);

        public double diffuseNorm2(int var1);

        public DataBlock M(int var1);

        public DataBlock Mi(int var1);

        public static VarianceFilterProvider of(final BaseDiffuseFilteringResults fr2) {
            return new VarianceFilterProvider(){

                @Override
                public int size() {
                    return fr2.size();
                }

                @Override
                public int endDiffusePosition() {
                    return fr2.getEndDiffusePosition();
                }

                @Override
                public boolean isMissing(int pos) {
                    return fr2.isMissing(pos);
                }

                @Override
                public double errorVariance(int pos) {
                    return fr2.errorVariance(pos);
                }

                @Override
                public double diffuseNorm2(int pos) {
                    return fr2.diffuseNorm2(pos);
                }

                @Override
                public DataBlock M(int pos) {
                    return fr2.M(pos);
                }

                @Override
                public DataBlock Mi(int pos) {
                    return fr2.Mi(pos);
                }
            };
        }

        public static VarianceFilterProvider of(final DefaultFilteringResults fr2) {
            return new VarianceFilterProvider(){

                @Override
                public int size() {
                    return fr2.size();
                }

                @Override
                public int endDiffusePosition() {
                    return 0;
                }

                @Override
                public boolean isMissing(int pos) {
                    return fr2.isMissing(pos);
                }

                @Override
                public double errorVariance(int pos) {
                    return fr2.errorVariance(pos);
                }

                @Override
                public double diffuseNorm2(int pos) {
                    return 0.0;
                }

                @Override
                public DataBlock M(int pos) {
                    return fr2.M(pos);
                }

                @Override
                public DataBlock Mi(int pos) {
                    return DataBlock.EMPTY;
                }
            };
        }
    }
}

