/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class VarLocalLinearTrend {
    public static StateComponent of(double[] lstd, double[] sstd, double lscale, double sscale) {
        Data data = new Data(lstd, sstd, lscale, sscale);
        return new StateComponent(new Initialization(), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    @Generated
    private VarLocalLinearTrend() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        final double lscale;
        final double sscale;
        final double lscale2;
        final double sscale2;
        final double[] lstd;
        final double[] sstd;

        Data(double[] lstd, double[] sstd, double lscale, double sscale) {
            this.lscale = lscale;
            this.lscale2 = lscale * lscale;
            this.lstd = lstd;
            this.sscale = sscale;
            this.sscale2 = sscale * sscale;
            this.sstd = sstd;
        }

        double svar(int pos) {
            if (this.sstd != null && pos < this.sstd.length) {
                double q = this.sstd[pos] * this.sscale;
                return q * q;
            }
            return this.sscale2;
        }

        double sstd(int pos) {
            return this.sstd != null && pos < this.sstd.length ? this.sscale * this.sstd[pos] : this.sscale;
        }

        double lvar(int pos) {
            if (this.lstd != null && pos < this.lstd.length) {
                double q = this.lstd[pos] * this.lscale;
                return q * q;
            }
            return this.lscale2;
        }

        double lstd(int pos) {
            return this.lstd != null && pos < this.lstd.length ? this.lscale * this.lstd[pos] : this.lscale;
        }
    }

    public static class Initialization
    implements ISsfInitialization {
        @Override
        public int getStateDim() {
            return 2;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return 2;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            pi0.diagonal().set(1.0);
        }
    }

    public static class Dynamics
    implements ISsfDynamics {
        private final Data data;

        Dynamics(Data data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return false;
        }

        @Override
        public int getInnovationsDim() {
            int n = 0;
            if (this.data.lscale > 0.0) {
                ++n;
            }
            if (this.data.sscale > 0.0) {
                ++n;
            }
            return n;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            if (this.data.lscale > 0.0) {
                qm.set(0, 0, this.data.lvar(pos));
            }
            if (this.data.sscale > 0.0) {
                qm.set(1, 1, this.data.svar(pos));
            }
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.lscale != 0.0 || this.data.sscale != 0.0;
        }

        @Override
        public void S(int pos, FastMatrix s) {
            s.set(0, 0, this.data.lstd(pos));
            s.set(1, 1, this.data.sstd(pos));
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(0, this.data.lstd(pos) * u.get(0));
            x.add(1, this.data.sstd(pos) * u.get(1));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, this.data.lstd(pos) * x.get(0));
            xs.set(1, this.data.sstd(pos) * x.get(1));
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, 1.0);
            tr.set(0, 1, 1.0);
            tr.set(1, 1, 1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.add(0, x.get(1));
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            double v01 = vm.get(0, 1);
            double v11 = vm.get(1, 1);
            vm.add(0, 0, 2.0 * v01 + v11);
            vm.add(0, 1, v11);
            vm.add(1, 0, v11);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.add(1, x.get(0));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.data.lvar(pos));
            p.add(1, 1, this.data.svar(pos));
        }
    }
}

