/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;

public class Gls {
    public LeastSquaresResults compute(LinearModel model, FastMatrix cov) {
        FastMatrix L = cov.deepClone();
        try {
            SymmetricMatrix.lcholesky(L);
            DataBlock yl = DataBlock.of(model.getY());
            LowerTriangularMatrix.solveLx(L, yl);
            FastMatrix xl = model.variables();
            LowerTriangularMatrix.solveLX(L, xl);
            QRLeastSquaresSolution solution = QRLeastSquaresSolver.robustLeastSquares((DoubleSeq)yl, xl);
            FastMatrix bvar = solution.unscaledCovariance();
            return LeastSquaresResults.builder((DoubleSeq)yl, xl).mean(model.isMeanCorrection()).estimation(solution.getB(), bvar).ssq(solution.getSsqErr()).residuals(solution.getE()).logDeterminant(2.0 * LogSign.of((DoubleSeq)L.diagonal()).getValue()).build();
        }
        catch (Exception err) {
            throw new EcoException("Gls failed");
        }
    }
}

