/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.AbstractList;
import jdplus.toolkit.base.api.timeseries.calendars.EasterRelatedDay;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayInfo;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class EasterDayInfo
implements HolidayInfo {
    private final LocalDate day;

    EasterDayInfo(int year, int offset, boolean julian) {
        LocalDate easter = EasterRelatedDay.easter((int)year, (boolean)julian);
        this.day = easter.plusDays(offset);
    }

    @Override
    public LocalDate getDay() {
        return this.day;
    }

    @Override
    public DayOfWeek getDayOfWeek() {
        return this.day.getDayOfWeek();
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasterDayInfo)) {
            return false;
        }
        EasterDayInfo other = (EasterDayInfo)o;
        LocalDate this$day = this.getDay();
        LocalDate other$day = other.getDay();
        return !(this$day == null ? other$day != null : !((Object)this$day).equals(other$day));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $day = this.getDay();
        result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "EasterDayInfo(day=" + String.valueOf(this.getDay()) + ")";
    }

    static class EasterDayList
    extends AbstractList<HolidayInfo> {
        private final int startyear;
        private final int n;
        private final int offset;
        private final boolean julian;

        public EasterDayList(int offset, boolean julian, LocalDate fstart, LocalDate fend) {
            this.offset = offset;
            this.julian = julian;
            int ystart = fstart.getYear();
            int yend = fend.getYear();
            LocalDate xday = EasterRelatedDay.easter((int)ystart, (boolean)julian).plusDays(offset);
            LocalDate yday = EasterRelatedDay.easter((int)yend, (boolean)julian).plusDays(offset);
            if (xday.isBefore(fstart)) {
                ++ystart;
            }
            if (yday.isBefore(fend)) {
                ++yend;
            }
            this.n = yend - ystart;
            this.startyear = ystart;
        }

        @Override
        public HolidayInfo get(int index) {
            return new EasterDayInfo(this.startyear + index, this.offset, this.julian);
        }

        @Override
        public int size() {
            return this.n;
        }
    }
}

