/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IAutoModellingModule;
import jdplus.toolkit.base.core.regsarima.regular.IDifferencingModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.x13.base.core.x13.regarima.ArmaModule;
import jdplus.x13.base.core.x13.regarima.DifferencingModule;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AutoModellingModule
implements IAutoModellingModule {
    public static final String AMI = "automatic arima selection";
    public static final String ARMA = "arma selection";
    public static final String MODEL = "selected model: ";
    public static final String DIFF_DEFAULT = "default differencing selected (esttimation failed";
    public static final String SELECTION = "differencing selection";
    public static final String DEFAULT = "default model selected ";
    public static final String MEAN = "mean correction";
    public static final String NOMEAN = "no mean correction";
    public static final String FAILED = "differencing selection failed";
    private final DifferencingModule iddiff;
    private final ArmaModule amdid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling modelling) {
        SarimaOrders nspec;
        boolean nmean;
        if (modelling.needEstimation()) {
            return ProcessingResult.Failed;
        }
        ModelDescription description = modelling.getDescription();
        RegArimaEstimation estimation = modelling.getEstimation();
        int period = description.getAnnualFrequency();
        SarimaOrders curspec = description.specification();
        boolean curMean = description.isMean();
        ProcessingLog log = modelling.getLog();
        log.push(AMI);
        try {
            DoubleSeq dres;
            int nbd;
            int nd;
            DoubleSeq res = RegArimaUtility.linearizedData((RegArimaModel)estimation.getModel(), (ConcentratedLikelihoodWithMissing)estimation.getConcentratedLikelihood());
            if (this.iddiff.process(res, period)) {
                nd = this.iddiff.getD();
                nbd = this.iddiff.getBd();
                nmean = this.iddiff.isMeanCorrection();
                log.info(SELECTION, (Object)IDifferencingModule.Info.of((IDifferencingModule)this.iddiff));
            } else {
                nd = 1;
                nbd = 1;
                nmean = false;
                log.remark(FAILED);
            }
            if (nd != 0 || nbd != 0) {
                BackFilter ur = new BackFilter(UnitRoots.D((int)nd).times(UnitRoots.D((int)period, (int)nbd)));
                DataBlock tmp = DataBlock.make((int)(res.length() - ur.getDegree()));
                ur.apply(res, (DoubleSeq.Mutable)tmp);
                dres = tmp.unmodifiable();
            } else {
                dres = res;
            }
            SarmaOrders rsltSpec = this.amdid.select(dres, period, nd, nbd);
            ArmaModule.RegArmaBic[] models = this.amdid.getPreferedModels();
            log.info(MODEL + rsltSpec.toString(), (Object)new ArmaModule.CInfo(models, rsltSpec));
            nspec = SarimaOrders.of((SarmaOrders)rsltSpec, (int)nd, (int)nbd);
        }
        catch (RuntimeException err) {
            nspec = SarimaOrders.airline((int)period);
            nmean = false;
            log.remark(DEFAULT);
        }
        finally {
            log.pop();
        }
        boolean changed = false;
        if (!curspec.equals((Object)nspec)) {
            description.setSpecification(nspec);
            changed = true;
        }
        if (nmean != curMean) {
            description.setMean(nmean);
            changed = true;
        }
        if (changed) {
            modelling.clearEstimation();
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    static SarimaOrders calcmaxspec(int freq, int inic, int d, int bd) {
        SarimaOrders spec = new SarimaOrders(freq);
        spec.setD(d);
        spec.setBd(bd);
        spec.setP(2);
        spec.setQ(2);
        if (freq > 1) {
            spec.setBp(1);
            spec.setBq(1);
        }
        return spec;
    }

    @Generated
    public AutoModellingModule(DifferencingModule iddiff, ArmaModule amdid) {
        this.iddiff = iddiff;
        this.amdid = amdid;
    }

    @Generated
    public DifferencingModule getIddiff() {
        return this.iddiff;
    }

    @Generated
    public ArmaModule getAmdid() {
        return this.amdid;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoModellingModule)) {
            return false;
        }
        AutoModellingModule other = (AutoModellingModule)o;
        DifferencingModule this$iddiff = this.getIddiff();
        DifferencingModule other$iddiff = other.getIddiff();
        if (this$iddiff == null ? other$iddiff != null : !this$iddiff.equals(other$iddiff)) {
            return false;
        }
        ArmaModule this$amdid = this.getAmdid();
        ArmaModule other$amdid = other.getAmdid();
        return !(this$amdid == null ? other$amdid != null : !this$amdid.equals(other$amdid));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DifferencingModule $iddiff = this.getIddiff();
        result = result * 59 + ($iddiff == null ? 43 : $iddiff.hashCode());
        ArmaModule $amdid = this.getAmdid();
        result = result * 59 + ($amdid == null ? 43 : $amdid.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "AutoModellingModule(iddiff=" + String.valueOf(this.getIddiff()) + ", amdid=" + String.valueOf(this.getAmdid()) + ")";
    }
}

