/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;

public class HyperPipes
extends Classifier {
    static final long serialVersionUID = -7527596632268975274L;
    protected int m_ClassIndex;
    protected Instances m_Instances;
    protected HyperPipe[] m_HyperPipes;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Class implementing a HyperPipe classifier. For each category a HyperPipe is constructed that contains all points of that category (essentially records the attribute bounds observed for each category). Test instances are classified according to the category that \"most contains the instance\".\nDoes not handle numeric class, or missing values in test cases. Extremely simple algorithm, but has the advantage of being extremely fast, and works quite well when you have \"smegloads\" of attributes.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_ClassIndex = instances.classIndex();
        this.m_Instances = new Instances(instances, 0);
        this.m_HyperPipes = new HyperPipe[instances.numClasses()];
        int i = 0;
        while (i < this.m_HyperPipes.length) {
            this.m_HyperPipes[i] = new HyperPipe(new Instances(instances, 0));
            ++i;
        }
        i = 0;
        while (i < instances.numInstances()) {
            this.updateClassifier(instances.instance(i));
            ++i;
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (instance.classIsMissing()) {
            return;
        }
        this.m_HyperPipes[(int)instance.classValue()].addInstance(instance);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] dist = new double[this.m_HyperPipes.length];
        int j = 0;
        while (j < this.m_HyperPipes.length) {
            dist[j] = this.m_HyperPipes[j].partialContains(instance);
            ++j;
        }
        double sum = Utils.sum(dist);
        if (sum <= 0.0) {
            int j2 = 0;
            while (j2 < dist.length) {
                dist[j2] = 1.0 / (double)dist.length;
                ++j2;
            }
            return dist;
        }
        Utils.normalize(dist, sum);
        return dist;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(this.getClass().getName().replaceAll(".*\\.", "")) + "\n");
            buf.append(String.valueOf(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=")) + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        if (this.m_HyperPipes == null) {
            return "HyperPipes classifier";
        }
        StringBuffer text = new StringBuffer("HyperPipes classifier\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5528 $");
    }

    public static void main(String[] argv) {
        HyperPipes.runClassifier(new HyperPipes(), argv);
    }

    class HyperPipe
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 3972254260367902025L;
        protected double[][] m_NumericBounds;
        protected boolean[][] m_NominalBounds;

        public HyperPipe(Instances instances) throws Exception {
            this.m_NumericBounds = new double[instances.numAttributes()][];
            this.m_NominalBounds = new boolean[instances.numAttributes()][];
            int i = 0;
            while (i < instances.numAttributes()) {
                switch (instances.attribute(i).type()) {
                    case 0: {
                        this.m_NumericBounds[i] = new double[2];
                        this.m_NumericBounds[i][0] = Double.POSITIVE_INFINITY;
                        this.m_NumericBounds[i][1] = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    case 1: {
                        this.m_NominalBounds[i] = new boolean[instances.attribute(i).numValues()];
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeTypeException("Cannot process string attributes!");
                    }
                }
                ++i;
            }
            i = 0;
            while (i < instances.numInstances()) {
                this.addInstance(instances.instance(i));
                ++i;
            }
        }

        public void addInstance(Instance instance) throws Exception {
            int j = 0;
            while (j < instance.numAttributes()) {
                if (j != HyperPipes.this.m_ClassIndex && !instance.isMissing(j)) {
                    double current = instance.value(j);
                    if (this.m_NumericBounds[j] != null) {
                        if (current < this.m_NumericBounds[j][0]) {
                            this.m_NumericBounds[j][0] = current;
                        }
                        if (current > this.m_NumericBounds[j][1]) {
                            this.m_NumericBounds[j][1] = current;
                        }
                    } else {
                        this.m_NominalBounds[j][(int)current] = true;
                    }
                }
                ++j;
            }
        }

        public double partialContains(Instance instance) throws Exception {
            int count = 0;
            int i = 0;
            while (i < instance.numAttributes()) {
                if (i != HyperPipes.this.m_ClassIndex && !instance.isMissing(i)) {
                    double current = instance.value(i);
                    if (this.m_NumericBounds[i] != null) {
                        if (current >= this.m_NumericBounds[i][0] && current <= this.m_NumericBounds[i][1]) {
                            ++count;
                        }
                    } else if (this.m_NominalBounds[i][(int)current]) {
                        ++count;
                    }
                }
                ++i;
            }
            return (double)count / (double)(instance.numAttributes() - 1);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5528 $");
        }
    }
}

