/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.vikamine.kernel.data.AbstractDataRecord;
import org.vikamine.kernel.data.DataRecord;

public class SparseDataRecord
extends AbstractDataRecord {
    protected Map<Integer, Double> attributeValues = new HashMap<Integer, Double>();

    public SparseDataRecord() {
    }

    public SparseDataRecord(double weight) {
        super(weight);
    }

    protected SparseDataRecord(Map<Integer, Double> attributeValues, double weight) {
        super(weight);
        this.attributeValues = attributeValues;
    }

    @Override
    public double getValue(int index) {
        Double result = this.attributeValues.get(index);
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    public Iterator<Map.Entry<Integer, Double>> getNonZeroAttributeValueEntriesIterator() {
        return this.attributeValues.entrySet().iterator();
    }

    @Override
    public DataRecord copy() {
        SparseDataRecord copy = new SparseDataRecord(this.getWeight());
        copy.attributeValues = new HashMap<Integer, Double>(this.attributeValues);
        copy.setDataset(this.getDataset());
        return copy;
    }

    @Override
    public synchronized void deleteAttributeAt(int index) {
        HashMap<Integer, Double> newAttributeValues = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> entry : this.attributeValues.entrySet()) {
            if (entry.getKey() > index) {
                newAttributeValues.put(entry.getKey() - 1, entry.getValue());
                continue;
            }
            newAttributeValues.put(entry.getKey(), entry.getValue());
        }
        this.attributeValues = newAttributeValues;
    }

    @Override
    public synchronized void insertAttributeAt(int index) {
        HashMap<Integer, Double> newAttributeValues = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> entry : this.attributeValues.entrySet()) {
            if (entry.getKey() >= index) {
                newAttributeValues.put(entry.getKey() + 1, entry.getValue());
                continue;
            }
            newAttributeValues.put(entry.getKey(), entry.getValue());
        }
        this.attributeValues = newAttributeValues;
        this.attributeValues.put(index, Double.NaN);
    }

    @Override
    public void setValue(int attIndex, double value) {
        this.attributeValues.put(attIndex, value);
    }
}

