## ----knitr-mechanics----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----pre-setup----------------------------------------------------------------
# devtools::install_github("njlyon0/supportR", force = TRUE)

## ----github_ls-1--------------------------------------------------------------
# # List all files in a GitHub repository
# supportR::github_ls(repo = "https://github.com/njlyon0/supportR",
#                     recursive = TRUE, quiet = FALSE)
# 
# ##                          name type                path
# ## 1               .Rbuildignore file                   .
# ## 2                     .github  dir                   .
# ## 3                  .gitignore file                   .
# ## 4                 DESCRIPTION file                   .
# ## 5                     LICENSE file                   .

## ----github_ls-2--------------------------------------------------------------
# # Or list files in only a particular folder
# supportR::github_ls(repo = "https://github.com/njlyon0/supportR", folder = "R",
#                     recursive = FALSE, quiet = TRUE)
# 
# ##                   name type path
# ## 1         array_melt.R file    R
# ## 2              count.R file    R
# ## 3           crop_tri.R file    R
# ## 4         date_check.R file    R

## ----github_tree--------------------------------------------------------------
# # Create a file tree diagram of a GitHub repository
# supportR::github_tree(repo = "https://github.com/njlyon0/supportR",
#                       exclude = c("docs", "man", ".github"), quiet = FALSE)
# 
# ##                               levelName
# ## 1  .
# ## 2   ¦--.Rbuildignore
# ## 3   ¦--.github
# ## 4   ¦   °--11 excluded items
# ## 5   ¦--.gitignore
# ## 6   ¦--DESCRIPTION
# ## 7   ¦--LICENSE

## ----tabularize_md------------------------------------------------------------
# # Identify URL to the NEWS.md file in `supportR` GitHub repo
# md_cxn <- url("https://raw.githubusercontent.com/njlyon0/supportR/main/NEWS.md")
# 
# # Transform it into a table
# md_df <- supportR::tabularize_md(file = md_cxn)
# 
# # Close connection (just good housekeeping to do so)
# close(md_cxn)
# 
# # Check out the table format
# str(md_df)
# 
# ## 'data.frame':	25 obs. of  2 variables:
# ##  $ level_1: chr  "supportR Version 1.4.0.900" "supportR Version 1.4.0.900" "supportR Version 1.4.0" "supportR Version 1.4.0" ...
# ##  $ text   : chr  "Development version, changes from preceding version are listed below:" "- Function fix: Fixed issue with `replace_non_ascii` where if `include_letters` was set to `FALSE` a warning wa"| __truncated__ "Changes from preceding version are listed below" "- New function: `replace_non_ascii`. Replaces non-ASCII characters with ASCII characters that are as visually s"| __truncated__

## ----rmd_export---------------------------------------------------------------
# # Authorize R to interact with GoogleDrive
# googledrive::drive_auth()
# 
# # Use `rmd_export()` to knit and export an .Rmd file
# supportR::rmd_export(rmd = "my_markdown.Rmd",
#                      in_path = file.path("Folder in my WD with the .Rmd named in `rmd`"),
#                      out_path = file.path("Folder in my WD to save the knit file to"),
#                      out_name = "desired name for output",
#                      out_type = "html",
#                      drive_link = "<Full Google Drive link>")

