## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----message=FALSE------------------------------------------------------------
library(dplyr)
library(blockstrap)

## ----message=FALSE------------------------------------------------------------
library(HospitalNetwork)
set.seed(1)
subject_db <- create_fake_subjectDB()

head(subject_db)

## -----------------------------------------------------------------------------
grouped_subjects <- subject_db |>  
  group_by(sID) |>
  mutate(Adate = as.Date(Adate),
         Ddate = as.Date(Ddate)) |>
  arrange(Adate, .by_group= TRUE) |>
  mutate(diff_time = Adate - lag(Ddate),
         is_start = is.na(diff_time) | diff_time > 40,
         idx_within_sid = cumsum(is_start),
         idx_block = as.factor(paste0(sID, "_",   idx_within_sid)))

head(grouped_subjects)


## -----------------------------------------------------------------------------
nrow(distinct(grouped_subjects,idx_block))

## -----------------------------------------------------------------------------
blockstrapped_db <- grouped_subjects |>
  group_by(idx_block) |>
  slice_block(n = 10, replace=TRUE)

head(blockstrapped_db)

## -----------------------------------------------------------------------------
blockstrapped_db <- grouped_subjects |>
  group_by(idx_block) |>
  slice_block(n = 10, replace=TRUE, weight_by = n())

blockstrapped_db

