library("exams")
library("exams.forge")

latex <- pkg_files("plain.tex")
inst  <- pkg_files("exam.rmarkdown")

files <- pkg_files("aufgaben/zufallsvariable/.*\\.Rmd")
for (i in seq_along(files)) {
  f <- try(readLines(files[i]), silent = TRUE)
  if (inherits(f, "try-error")) print(files[i])
}
  

options(warn = 0)
for (i in seq_along(files)) {
  cat(files[i], sep="\n")
#  if (i>85) options(warn = 2)
  exams2html(expar(files[i], instruction=inst))
}
options(warn = 0)

for (i in seq_along(files)) {
  cat(files[i], sep="\n")
  exams2pdf(files[i], template=latex)
}

exams2pdf(files, template=latex, texdir="~/Seafile/Temp/tmp")

#files <- pkg_files("zeitreihe/.*\\.Rmd")
exams2html(vexpar(files, instruction=inst))
exams2pdf(files, template=latex)