## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----cran, eval = FALSE-------------------------------------------------------
# install.packages("fluxfixer")

## ----github, eval = FALSE-----------------------------------------------------
# # install.packages("remotes")
# remotes::install_github("yhata86/fluxfixer")

## ----setup, message = FALSE, warning = FALSE----------------------------------
library(fluxfixer)

## ----vign_raw-----------------------------------------------------------------
## Load sample data
data("dt_noisy")

## ----vign_checkraw, eval = FALSE----------------------------------------------
# ## Just for the visualization
# # install.packages("ggplot2)
# library(ggplot2)
# 
# ## Set the period you want to check
# time_head <- as.POSIXct("2012/09/01 00:30", tz = "Etc/GMT-8")
# time_tail <- as.POSIXct("2013/09/01 00:00", tz = "Etc/GMT-8")
# 
# dt_noisy %>%
#   dplyr::mutate(dplyr::across(tidyselect::where(is.numeric),
#                               ~dplyr::na_if(., -9999))) %>%
#   ggplot2::ggplot()+
#   scale_x_datetime(limits = c(time_head, time_tail))+
#   geom_point(aes(time, dt), col = "royalblue")

## ----vign_auto, eval = FALSE--------------------------------------------------
# ## Specify the period of the short-term drift
# time_drft_head <- as.POSIXct("2013/05/14 13:30", tz = "Etc/GMT-8")
# time_drft_tail <- as.POSIXct("2013/05/17 15:00", tz = "Etc/GMT-8")
# 
# ## Specify the sensor replacement timing
# time_prd_tail <- as.POSIXct("2013/05/14 13:00", tz = "Etc/GMT-8")
# 
# ## Run all processes automatically
# result <-
#   run_fluxfixer(df = dt_noisy,
#                 colname_time = "time",
#                 colname_target = "dt",
#                 vctr_time_drft_head = time_drft_head,
#                 vctr_time_drft_tail = time_drft_tail,
#                 vctr_time_prd_tail = time_prd_tail,
#                 detrend = TRUE)

## ----vign_checkresult, eval = FALSE-------------------------------------------
# ## Set the period you want to check
# time_head <- as.POSIXct("2012/09/01 00:30", tz = "Etc/GMT-8")
# time_tail <- as.POSIXct("2013/09/01 00:00", tz = "Etc/GMT-8")
# 
# result %>%
#   dplyr::mutate(dplyr::across(tidyselect::where(is.numeric),
#                               ~dplyr::na_if(., -9999))) %>%
#   ggplot2::ggplot()+
#   scale_x_datetime(limits = c(time_head, time_tail))+
#   geom_point(aes(time, raw), col = "royalblue", alpha = 0.01)+
#   geom_point(aes(time, processed), col = "orange", alpha = 0.1)

## ----vign_loadagain-----------------------------------------------------------
## Load sample data
data("dt_noisy")

## ----vign_al, eval = FALSE----------------------------------------------------
# ## Conduct the absolute limit test
# df_all <-
#   dt_noisy %>%
#   dplyr::mutate(dt_al = check_absolute_limits(vctr_target = dt))

## ----vign_sdc, eval = FALSE---------------------------------------------------
# ## Specify the period of the short-term drift
# time_drft_head <- as.POSIXct("2013/05/14 13:30", tz = "Etc/GMT-8")
# time_drft_tail <- as.POSIXct("2013/05/17 15:00", tz = "Etc/GMT-8")
# 
# ## Conduct the short-term drift correction
# df_all <-
#   df_all %>%
#   dplyr::mutate(dt_sdc = modify_short_drift(vctr_time = time,
#                                             vctr_target = dt_al,
#                                             vctr_time_drft_head = time_drft_head,
#                                             vctr_time_drft_tail = time_drft_tail))

## ----vign_zs, eval = FALSE----------------------------------------------------
# ## Specify the sensor replacement timing
# time_prd_tail <- as.POSIXct("2013/05/14 13:00", tz = "Etc/GMT-8")
# 
# ## Conduct the Z-score outlier removal
# df_z <-
#   remove_zscore_outlier(vctr_time = df_all$time,
#                         vctr_target = df_all$dt_sdc,
#                         vctr_time_prd_tail = time_prd_tail)
# 
# df_all <-
#   df_z %>%
#   dplyr::select(z_cleaned, avg_cleaned, sd_cleaned) %>%
#   dplyr::bind_cols(df_all, .)

## ----vign_rf, eval = FALSE----------------------------------------------------
# ## Conduct the random forest outlier removal
# df_rf <-
#   remove_rf_outlier(df = df_all,
#                     colname_label = "z_cleaned",
#                     vctr_colname_feature = c("p", "sw_in", "ta", "vpd", "ws", "swc"))
# 
# df_all <-
#   df_all %>%
#   dplyr::mutate(z_rf = df_rf$stats$cleaned)

## ----vign_crs, eval = FALSE---------------------------------------------------
# ## Calculate the reference values of average and standard deviation
# vctr_stats_ref <-
#         data.frame(z_target = df_all$z_rf,
#                    avg_target = df_z$avg_cleaned,
#                    sd_target = df_z$sd_cleaned) %>%
#         dplyr::mutate(target = ifelse(z_target != -9999 &
#                                         avg_target != -9999 &
#                                         sd_target != -9999,
#                                       z_target * sd_target + avg_target,
#                                       -9999)) %>%
#         dplyr::pull(target) %>%
#         calc_ref_stats(vctr_time = df_all$time,
#                        vctr_target = .,
#                        vctr_time_prd_tail = time_prd_tail)

## ----vign_gf, eval = FALSE----------------------------------------------------
# ## Fill all the missing values by the random forest model
# df_gf <-
#   fill_gaps(df = df_all,
#             colname_label = "z_rf",
#             vctr_colname_feature = c("p", "sw_in", "ta", "vpd", "ws", "swc"))
# 
# df_all <-
#   df_all %>%
#   dplyr::mutate(z_gf = df_gf$stats$gapfilled)

## ----vign_rt, eval = FALSE----------------------------------------------------
# ## Retrieve the time series in its original units
# df_all <-
#   df_all %>%
#   dplyr::mutate(dt_processed = retrieve_ts(vctr_target_z = df_all$z_gf,
#                                            vctr_target_sd = df_all$sd_cleaned,
#                                            detrend = TRUE,
#                                            avg_ref = vctr_stats_ref[1]))

## ----vign_dtmax, eval = FALSE-------------------------------------------------
# ## Calculate dTmax by the SP and PD methods
# df_dtmax <-
#   calc_dtmax(vctr_time = df_all$time,
#              vctr_dt = df_all$dt_processed,
#              vctr_radi = df_all$sw_in,
#              method = c("sp", "pd"))
# 
# df_all <-
#   df_dtmax %>%
#   dplyr::select(dtmax_sp, dtmax_pd) %>%
#   dplyr::bind_cols(df_all, .)

## ----vign_fd, eval = FALSE----------------------------------------------------
# ## Calculate Fd using the dTmax estimated by the SP and PD methods
# df_all <-
#   df_all %>%
#   dplyr::mutate(fd_sp = calc_fd(vctr_dt = dt_processed,
#                                 vctr_dtmax = dtmax_sp),
#                 fd_pd = calc_fd(vctr_dt = dt_processed,
#                                 vctr_dtmax = dtmax_pd))

