/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.List;

public final class Exactly
extends AbstractLargeIntSConstraint {
    private final int value;
    private final int nb_vars;
    private final int N;
    private final List<IntDomainVar> BOTH;

    public Exactly(IntDomainVar[] vars, int N, int value) {
        super(ConstraintEvent.LINEAR, vars);
        this.nb_vars = vars.length;
        this.value = value;
        this.N = N;
        this.BOTH = new ArrayList<IntDomainVar>(this.nb_vars);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.BOTH.clear();
        int lb = 0;
        int ub = this.nb_vars;
        for (int i = 0; i < this.nb_vars; ++i) {
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            if (var.canBeInstantiatedTo(this.value)) {
                if (var.isInstantiatedTo(this.value)) {
                    ++lb;
                    continue;
                }
                this.BOTH.add(var);
                continue;
            }
            --ub;
        }
        int min = Math.max(this.N, lb);
        int max = Math.min(this.N, ub);
        if (max < min) {
            this.fail();
        }
        if (lb == min && lb == max) {
            for (IntDomainVar var : this.BOTH) {
                var.removeVal(this.value, this, false);
            }
            this.setEntailed();
        }
        if (ub == min && ub == max) {
            for (IntDomainVar var : this.BOTH) {
                var.instantiate(this.value, this, false);
            }
            this.setEntailed();
        }
    }

    @Override
    public boolean isSatisfied() {
        int nbToValue = 0;
        int nbNotToValue = 0;
        for (int i = 0; i < this.nb_vars; ++i) {
            if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(this.value)) {
                ++nbToValue;
                continue;
            }
            if (((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(this.value)) continue;
            ++nbNotToValue;
        }
        return nbToValue == this.N && nbToValue + nbNotToValue == this.nb_vars;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int nb = 0;
        for (int tu : tuple) {
            if (tu != this.value) continue;
            ++nb;
        }
        return nb == this.N;
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer("EXACTLY(");
        sb.append(this.N).append(",[");
        for (int i = 0; i < this.nb_vars; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((IntDomainVar[])this.vars)[i].pretty());
        }
        sb.append("],").append(this.value).append(")");
        return sb.toString();
    }
}

