## ----include = FALSE----------------------------------------------------------
# Preview vignette with: devtools::build_rmd("vignettes/palettes.Rmd")
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(palettes)

## -----------------------------------------------------------------------------
colour_vector <- pal_colour(
  c("#a00e00", "#d04e00", "#f6c200", "#0086a8", "#132b69")
)

colour_vector

## -----------------------------------------------------------------------------
colour_palette <- pal_palette(
  egypt = c("#dd5129", "#0f7ba2", "#43b284", "#fab255"),
  java  = c("#663171", "#cf3a36", "#ea7428", "#e2998a", "#0c7156")
)

colour_palette

## -----------------------------------------------------------------------------
colour_strings <- c("orange", "purple")
as_colour(colour_strings)

## -----------------------------------------------------------------------------
colour_list <- list(OrPu = c("orange", "purple"))
as_palette(colour_list)

## -----------------------------------------------------------------------------
as_tibble(colour_vector)

as_tibble(colour_palette)

## -----------------------------------------------------------------------------
colour_vector[3]

## -----------------------------------------------------------------------------
colour_vector[-3]

## -----------------------------------------------------------------------------
c(colour_vector[-3], colour_vector[3])

## -----------------------------------------------------------------------------
colour_palette["egypt"]

## -----------------------------------------------------------------------------
colour_palette[["egypt"]]

colour_palette$egypt

## -----------------------------------------------------------------------------
names(colour_palette)

## -----------------------------------------------------------------------------
pal_colour("red") + pal_colour("blue")

## -----------------------------------------------------------------------------
plot(colour_vector)

## -----------------------------------------------------------------------------
plot(colour_palette["egypt"])

## -----------------------------------------------------------------------------
plot(colour_palette)

## -----------------------------------------------------------------------------
plot(colour_vector, n = 7, direction = -1, interpolate = "linear")

## ----include=FALSE------------------------------------------------------------
op <- options()

## -----------------------------------------------------------------------------
options(palettes.print_symbol = "square")
colour_vector

## ----include=FALSE------------------------------------------------------------
options(op)

## -----------------------------------------------------------------------------
options(
  palettes.print_symbol = "circle_large",
  palettes.print_hex = FALSE,
  palettes.print_width = 5
)
colour_palette

## ----include=FALSE------------------------------------------------------------
options(op)

## -----------------------------------------------------------------------------
options(
  palettes.print_symbol = FALSE,
  palettes.print_sep = ", ",
  palettes.print_width = 5,
  palettes.print_index = TRUE
)
colour_vector

## ----include=FALSE------------------------------------------------------------
options(op)

