## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)

## ----type1--------------------------------------------------------------------
df <- data.frame(tt_ac01=c('1','2','3'),
                 tt_ac02=c('a','b','b'),
                 tt_ac03=c('10','11','12'))
repfun::ru_expvarlist(df, varsin="tt_ac:")

## ----type2--------------------------------------------------------------------
df <- data.frame(tt_ac01=c('1','2','3'),
                 tt_ac03=c('10','11','12'))
repfun::ru_expvarlist(df, varsin="tt_ac:")

## ----type3--------------------------------------------------------------------
df <- data.frame(tt_ac01=c('1','2','3'),
                 tt_ac03=c('10','11','12'))
repfun::ru_expvarlist(df, varsin="tt_ac01-tt_ac10")

