/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.count;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropCountVar
extends Propagator<IntVar> {
    private final int n;
    private final IntVar val;
    private final IntVar card;

    public PropCountVar(IntVar[] decvars, IntVar restrictedValue, IntVar valueCardinality) {
        super((Variable[])ArrayUtils.concat(decvars, valueCardinality, restrictedValue), (Priority)PropagatorPriority.QUADRATIC, false);
        this.n = decvars.length;
        this.card = ((IntVar[])this.vars)[this.n];
        this.val = ((IntVar[])this.vars)[this.n + 1];
    }

    @Override
    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("PropCountVar_(");
        for (i = 0; i < Math.min(4, ((IntVar[])this.vars).length - 1); ++i) {
            st.append(((IntVar[])this.vars)[i].getName()).append(", ");
        }
        if (i < ((IntVar[])this.vars).length - 2) {
            st.append("..., ");
        }
        st.append(((IntVar[])this.vars)[((IntVar[])this.vars).length - 1].getName());
        st.append(", value=").append(this.val.getName());
        st.append(", cardinality=").append(this.card.getName());
        return st.toString();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        int minCard = 0xCCCCCCC;
        int maxCard = -minCard;
        int cardLB = this.card.getLB();
        int cardUB = this.card.getUB();
        int value = this.val.getLB();
        while (value <= this.val.getUB()) {
            int min = 0;
            int max = 0;
            for (i = 0; i < this.n; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                if (!v.contains(value)) continue;
                ++max;
                if (!v.isInstantiated()) continue;
                ++min;
            }
            if (cardLB > max || cardUB < min) {
                this.val.removeValue(value, (ICause)this);
            } else {
                minCard = Math.min(minCard, min);
                maxCard = Math.max(maxCard, max);
            }
            value = this.val.nextValue(value);
        }
        this.card.updateBounds(minCard, maxCard, this);
        if (this.val.isInstantiated() && this.card.isInstantiated()) {
            int nb = this.card.getValue();
            int value2 = this.val.getValue();
            if (maxCard == nb) {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    if (!((IntVar[])this.vars)[i2].contains(value2)) continue;
                    ((IntVar[])this.vars)[i2].instantiateTo(value2, (ICause)this);
                }
                this.setPassive();
            } else if (minCard == nb) {
                int nbInst = 0;
                for (i = 0; i < this.n; ++i) {
                    if (!((IntVar[])this.vars)[i].contains(value2)) continue;
                    if (((IntVar[])this.vars)[i].isInstantiated()) {
                        ++nbInst;
                        continue;
                    }
                    ((IntVar[])this.vars)[i].removeValue(value2, (ICause)this);
                }
                this.card.instantiateTo(nbInst, (ICause)this);
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == ((IntVar[])this.vars).length - 2) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public ESat isEntailed() {
        boolean support = false;
        boolean instSupport = false;
        int value = this.val.getLB();
        while (value <= this.val.getUB()) {
            int min = 0;
            int max = 0;
            for (int i = 0; i < this.n; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                if (!v.contains(value)) continue;
                ++max;
                if (!v.isInstantiated()) continue;
                ++min;
            }
            if (this.card.getLB() <= max && this.card.getUB() >= min) {
                support = true;
                if (min == max) {
                    instSupport = true;
                }
            }
            value = this.val.nextValue(value);
        }
        if (!support) {
            return ESat.FALSE;
        }
        if (this.val.isInstantiated() && instSupport && this.card.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

