/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Iterator;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.EnumDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.EnumDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public final class BitsetIntVarImpl
extends AbstractVariable
implements IntVar {
    private boolean reactOnRemoval = false;
    private final IStateBitSet VALUES;
    private final IStateInt LB;
    private final IStateInt UB;
    private final IStateInt SIZE;
    private final int OFFSET;
    private final int LENGTH;
    private IEnumDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private IntVarValueIterator _javaIterator;
    protected SignedLiteral.Set literal;

    public BitsetIntVarImpl(String name, int[] sortedValues, Model model) {
        super(name, model);
        IEnvironment env = model.getEnvironment();
        this.OFFSET = sortedValues[0];
        int capacity = sortedValues[sortedValues.length - 1] - this.OFFSET + 1;
        this.VALUES = env.makeBitSet(capacity);
        for (int sortedValue : sortedValues) {
            this.VALUES.set(sortedValue - this.OFFSET);
        }
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(capacity - 1);
        this.SIZE = env.makeInt(this.VALUES.cardinality());
        this.LENGTH = capacity;
    }

    public BitsetIntVarImpl(String name, int min, int max, Model model) {
        super(name, model);
        IEnvironment env = this.model.getEnvironment();
        this.OFFSET = min;
        int capacity = max - min + 1;
        this.VALUES = env.makeBitSet(capacity);
        this.VALUES.set(0, max - min + 1);
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(max - min);
        this.SIZE = env.makeInt(capacity);
        this.LENGTH = capacity;
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        boolean change;
        assert (cause != null);
        int aValue = value - this.OFFSET;
        boolean bl = change = aValue >= 0 && aValue <= this.LENGTH && this.VALUES.get(aValue);
        if (change) {
            this.model.getSolver().getEventObserver().removeValue(this, value, cause);
            if (this.SIZE.get() == 1) {
                this.contradiction(cause, "remove last value");
            }
            IntEventType e = IntEventType.REMOVE;
            this.VALUES.clear(aValue);
            this.SIZE.add(-1);
            if (this.reactOnRemoval) {
                this.delta.add(value, cause);
            }
            if (value == this.getLB()) {
                this.LB.set(this.VALUES.nextSetBit(aValue));
                e = IntEventType.INCLOW;
            } else if (value == this.getUB()) {
                this.UB.set(this.VALUES.prevSetBit(aValue));
                e = IntEventType.DECUPP;
            }
            assert (!this.VALUES.isEmpty());
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
        }
        return change;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        int i;
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        if (nlb > oub || nub < olb) {
            return false;
        }
        while (nlb == olb && olb < Integer.MAX_VALUE) {
            i = this.VALUES.nextSetBit(nlb + 1 - this.OFFSET);
            olb = i > -1 ? i + this.OFFSET : Integer.MAX_VALUE;
            nlb = values.nextValue(olb - 1);
        }
        if (nlb <= nub) {
            while (nub == oub && oub > Integer.MIN_VALUE) {
                i = this.VALUES.prevSetBit(nub - 1 - this.OFFSET);
                oub = i > -1 ? i + this.OFFSET : Integer.MIN_VALUE;
                nub = values.previousValue(oub + 1);
            }
        }
        boolean hasChanged = this.updateBounds(olb, oub, cause);
        int value = nlb;
        int to = nub;
        boolean hasRemoved = false;
        int count = this.SIZE.get();
        while (value <= to) {
            int aValue = value - this.OFFSET;
            if (aValue >= 0 && aValue <= this.LENGTH && this.VALUES.get(aValue)) {
                this.model.getSolver().getEventObserver().removeValue(this, value, cause);
                if (count == 1) {
                    this.contradiction(cause, "remove last value");
                }
                --count;
                hasRemoved = true;
                this.VALUES.clear(aValue);
                if (this.reactOnRemoval) {
                    this.delta.add(value, cause);
                }
            }
            value = values.nextValue(value);
        }
        if (hasRemoved) {
            this.notifyRemovals(count, cause);
        }
        return hasRemoved || hasChanged;
    }

    private void notifyRemovals(int count, ICause cause) throws ContradictionException {
        this.SIZE.set(count);
        IntEventType e = IntEventType.REMOVE;
        if (count == 1) {
            e = IntEventType.INSTANTIATE;
        }
        this.notifyPropagators(e, cause);
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        int i;
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        while (nlb != olb && olb < Integer.MAX_VALUE && nlb < Integer.MAX_VALUE) {
            i = this.VALUES.nextSetBit(nlb - this.OFFSET);
            olb = i > -1 ? i + this.OFFSET : Integer.MAX_VALUE;
            nlb = values.nextValue(olb - 1);
        }
        if (nlb <= nub) {
            while (nub != oub && oub > Integer.MIN_VALUE && nub > Integer.MIN_VALUE) {
                i = this.VALUES.prevSetBit(nub - this.OFFSET);
                oub = i > -1 ? i + this.OFFSET : Integer.MIN_VALUE;
                nub = values.previousValue(oub + 1);
            }
        }
        boolean hasChanged = this.updateBounds(nlb, nub, cause);
        boolean hasRemoved = false;
        int count = this.SIZE.get();
        int m0 = values.nextValueOut(nlb);
        while (m0 < nub) {
            int m1 = values.nextValue(m0) - this.OFFSET;
            int f = this.VALUES.nextSetBit(m0 - this.OFFSET);
            int t = this.VALUES.nextClearBit(f);
            int k = f;
            while (k < m1) {
                if (k < t) {
                    int value = k + this.OFFSET;
                    assert (!values.contains(value));
                    this.model.getSolver().getEventObserver().removeValue(this, value, cause);
                    if (count == 1) {
                        this.contradiction(cause, "remove last value");
                    }
                    --count;
                    hasRemoved = true;
                    if (this.reactOnRemoval) {
                        this.delta.add(value, cause);
                    }
                    ++k;
                    continue;
                }
                this.VALUES.clear(f, t);
                k = f = this.VALUES.nextSetBit(t);
                t = this.VALUES.nextClearBit(f);
            }
            if (f < m1) {
                this.VALUES.clear(f, m1);
            }
            m0 = values.nextValueOut(m1 + this.OFFSET);
        }
        if (hasRemoved) {
            this.notifyRemovals(count, cause);
        }
        return hasRemoved || hasChanged;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean anyChange = false;
        int i = this.VALUES.nextSetBit(from - this.OFFSET);
        to -= this.OFFSET;
        int count = this.SIZE.get();
        while (i > -1 && i <= to) {
            int aValue = i + this.OFFSET;
            anyChange = true;
            --count;
            this.VALUES.clear(i);
            if (this.reactOnRemoval) {
                this.delta.add(aValue, cause);
            }
            this.model.getSolver().getEventObserver().removeValue(this, aValue, cause);
            i = this.VALUES.nextSetBit(i + 1);
        }
        if (anyChange) {
            this.SIZE.set(count);
            this.notifyPropagators(IntEventType.REMOVE, cause);
        }
        return anyChange;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (!this.contains(value)) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "the variable is already instantiated to another value");
        } else if (!this.isInstantiated()) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            int aValue = value - this.OFFSET;
            if (this.reactOnRemoval) {
                int i = this.VALUES.nextSetBit(this.LB.get());
                while (i < aValue) {
                    this.delta.add(i + this.OFFSET, cause);
                    i = this.VALUES.nextSetBit(i + 1);
                }
                i = this.VALUES.nextSetBit(aValue + 1);
                while (i >= 0) {
                    this.delta.add(i + this.OFFSET, cause);
                    i = this.VALUES.nextSetBit(i + 1);
                }
            }
            this.VALUES.clear();
            this.VALUES.set(aValue);
            this.LB.set(aValue);
            this.UB.set(aValue);
            this.SIZE.set(1);
            assert (!this.VALUES.isEmpty());
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            int oub = this.getUB();
            this.model.getSolver().getEventObserver().updateLowerBound(this, value, old, cause);
            if (oub < value) {
                this.contradiction(cause, "the new lower bound is greater than the current upper bound");
            } else {
                IntEventType e = IntEventType.INCLOW;
                int aValue = value - this.OFFSET;
                if (this.reactOnRemoval) {
                    int i = old - this.OFFSET;
                    while (i < aValue) {
                        this.delta.add(i + this.OFFSET, cause);
                        i = this.VALUES.nextSetBit(i + 1);
                    }
                }
                this.VALUES.clear(old - this.OFFSET, aValue);
                this.LB.set(this.VALUES.nextSetBit(aValue));
                assert (this.SIZE.get() > this.VALUES.cardinality());
                this.SIZE.set(this.VALUES.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int oub = this.getUB();
        if (oub > value) {
            int olb = this.getLB();
            this.model.getSolver().getEventObserver().updateUpperBound(this, value, oub, cause);
            if (olb > value) {
                this.contradiction(cause, "the new upper bound is lesser than the current lower bound");
            } else {
                IntEventType e = IntEventType.DECUPP;
                int aValue = value - this.OFFSET;
                if (this.reactOnRemoval) {
                    int i = oub - this.OFFSET;
                    while (i > aValue) {
                        this.delta.add(i + this.OFFSET, cause);
                        i = this.VALUES.prevSetBit(i - 1);
                    }
                }
                this.VALUES.clear(aValue + 1, oub - this.OFFSET + 1);
                this.UB.set(this.VALUES.prevSetBit(aValue));
                assert (this.SIZE.get() > this.VALUES.cardinality());
                this.SIZE.set(this.VALUES.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        boolean update = false;
        if (olb < lb || oub > ub) {
            int i;
            IntEventType e = null;
            if (oub < lb) {
                this.model.getSolver().getEventObserver().updateLowerBound(this, lb, olb, cause);
                this.contradiction(cause, "the new lower bound is greater than the current upper bound");
            } else if (olb < lb) {
                this.model.getSolver().getEventObserver().updateLowerBound(this, lb, olb, cause);
                e = IntEventType.INCLOW;
                int aLB = lb - this.OFFSET;
                if (this.reactOnRemoval) {
                    i = olb - this.OFFSET;
                    while (i < aLB) {
                        this.delta.add(i + this.OFFSET, cause);
                        i = this.VALUES.nextSetBit(i + 1);
                    }
                }
                this.VALUES.clear(olb - this.OFFSET, aLB);
                olb = this.VALUES.nextSetBit(aLB);
                this.LB.set(olb);
                this.SIZE.set(this.VALUES.cardinality());
                olb += this.OFFSET;
            }
            if (olb > ub) {
                this.model.getSolver().getEventObserver().updateUpperBound(this, ub, oub, cause);
                this.contradiction(cause, "the new upper bound is lesser than the current lower bound");
            } else if (oub > ub) {
                this.model.getSolver().getEventObserver().updateUpperBound(this, ub, oub, cause);
                e = e == null ? IntEventType.DECUPP : IntEventType.BOUND;
                int aUB = ub - this.OFFSET;
                if (this.reactOnRemoval) {
                    i = oub - this.OFFSET;
                    while (i > aUB) {
                        this.delta.add(i + this.OFFSET, cause);
                        i = this.VALUES.prevSetBit(i - 1);
                    }
                }
                this.VALUES.clear(aUB + 1, oub - this.OFFSET + 1);
                this.UB.set(this.VALUES.prevSetBit(aUB));
                this.SIZE.set(this.VALUES.cardinality());
            }
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            update = true;
        }
        return update;
    }

    @Override
    public boolean isInstantiated() {
        return this.SIZE.get() == 1;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.isInstantiated() && this.getLB() == value;
    }

    @Override
    public boolean contains(int aValue) {
        return this.LB.get() <= (aValue -= this.OFFSET) && aValue <= this.UB.get() && this.VALUES.get(aValue);
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public int getLB() {
        return this.LB.get() + this.OFFSET;
    }

    @Override
    public int getUB() {
        return this.UB.get() + this.OFFSET;
    }

    @Override
    public int getDomainSize() {
        return this.SIZE.get();
    }

    @Override
    public int getRange() {
        return this.getUB() - this.getLB() + 1;
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.LB.get();
        if ((aValue -= this.OFFSET) < 0 || aValue < lb) {
            return lb + this.OFFSET;
        }
        if ((aValue = this.VALUES.nextSetBit(aValue + 1)) > -1) {
            return aValue + this.OFFSET;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int aValue) {
        int lb = this.getLB();
        int ub = this.getUB();
        if (lb - 1 <= aValue && aValue <= ub) {
            return this.VALUES.nextClearBit(aValue - this.OFFSET + 1) + this.OFFSET;
        }
        return aValue + 1;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.UB.get();
        if ((aValue -= this.OFFSET) > ub) {
            return ub + this.OFFSET;
        }
        if ((aValue = this.VALUES.prevSetBit(aValue - 1)) > -1) {
            return aValue + this.OFFSET;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int aValue) {
        int lb = this.getLB();
        int ub = this.getUB();
        if (lb <= aValue && aValue <= ub + 1) {
            return this.VALUES.prevClearBit(aValue - this.OFFSET - 1) + this.OFFSET;
        }
        return aValue - 1;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(20);
        s.append(this.name).append(" = ");
        if (this.SIZE.get() == 1) {
            s.append(this.getLB());
        } else {
            int v = this.getLB();
            s.append('{').append(v);
            int w = this.nextValueOut(v);
            if (v < w - 1) {
                s.append("..").append(w - 1);
            }
            v = this.nextValue(w);
            while (v < Integer.MAX_VALUE) {
                s.append(",").append(v);
                w = this.nextValueOut(v);
                if (v < w - 1) {
                    s.append("..").append(w - 1);
                }
                v = this.nextValue(w);
            }
            s.append('}');
        }
        return s.toString();
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new EnumDelta(this.model.getEnvironment());
            this.reactOnRemoval = true;
        }
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new EnumDeltaMonitor(this.delta, propagator);
    }

    @Override
    public int getTypeAndKind() {
        return 9;
    }

    protected EvtScheduler createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                int value;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.value = BitsetIntVarImpl.this.LB.get();
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.value = BitsetIntVarImpl.this.UB.get();
                }

                @Override
                public boolean hasNext() {
                    return this.value != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.value != -1;
                }

                @Override
                public int next() {
                    int old = this.value;
                    this.value = BitsetIntVarImpl.this.VALUES.nextSetBit(this.value + 1);
                    return old + BitsetIntVarImpl.this.OFFSET;
                }

                @Override
                public int previous() {
                    int old = this.value;
                    this.value = BitsetIntVarImpl.this.VALUES.prevSetBit(this.value - 1);
                    return old + BitsetIntVarImpl.this.OFFSET;
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                int from;
                int to;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.from = BitsetIntVarImpl.this.VALUES.nextSetBit(0);
                    this.to = BitsetIntVarImpl.this.VALUES.nextClearBit(this.from + 1) - 1;
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.to = BitsetIntVarImpl.this.VALUES.prevSetBit(BitsetIntVarImpl.this.VALUES.size() - 1);
                    this.from = BitsetIntVarImpl.this.VALUES.prevClearBit(this.to) + 1;
                }

                @Override
                public boolean hasNext() {
                    return this.from != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.to != -1;
                }

                @Override
                public void next() {
                    this.from = BitsetIntVarImpl.this.VALUES.nextSetBit(this.to + 1);
                    this.to = BitsetIntVarImpl.this.VALUES.nextClearBit(this.from) - 1;
                }

                @Override
                public void previous() {
                    this.to = BitsetIntVarImpl.this.VALUES.prevSetBit(this.from - 1);
                    this.from = BitsetIntVarImpl.this.VALUES.prevClearBit(this.to) + 1;
                }

                @Override
                public int min() {
                    return this.from + BitsetIntVarImpl.this.OFFSET;
                }

                @Override
                public int max() {
                    return this.to + BitsetIntVarImpl.this.OFFSET;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this._javaIterator == null) {
            this._javaIterator = new IntVarValueIterator(this);
        }
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void createLit(IntIterableRangeSet rootDomain) {
        if (this.literal != null) {
            throw new IllegalStateException("createLit(Implications) called twice");
        }
        this.literal = new SignedLiteral.Set(rootDomain);
    }

    @Override
    public SignedLiteral getLit() {
        if (this.literal == null) {
            throw new NullPointerException("getLit() called on null, a call to createLit(Implications) is required");
        }
        return this.literal;
    }
}

