/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.Objects;
import standalone_spreadsheet.com.github.miachm.sods.Style;

public class ConditionalFormat
implements Cloneable {
    private Style apply;
    private String rawCondition;

    ConditionalFormat(Style apply, String rawCondition) {
        this.apply = apply;
        this.rawCondition = rawCondition;
    }

    public Style getStyleApplied() {
        return this.apply;
    }

    String getRawCondition() {
        return this.rawCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalFormat that = (ConditionalFormat)o;
        return this.apply.equals(that.apply) && this.rawCondition.equals(that.rawCondition);
    }

    public int hashCode() {
        return Objects.hash(this.apply, this.rawCondition);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static ConditionalFormat conditionWhenValueIsGreater(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()>" + value);
    }

    public static ConditionalFormat conditionWhenValueIsLower(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()<" + value);
    }

    public static ConditionalFormat conditionWhenValueIsEqual(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()=" + value);
    }

    public static ConditionalFormat conditionWhenValueIsEqual(Style apply, String value) {
        return new ConditionalFormat(apply, "cell-content()=\"" + value + "\"");
    }

    public static ConditionalFormat conditionWhenValueIsGreaterOrEqual(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()>=" + value);
    }

    public static ConditionalFormat conditionWhenValueIsLowerOrEqual(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()<=" + value);
    }

    public static ConditionalFormat conditionWhenValueIsNotEqual(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()!=" + value);
    }

    public static ConditionalFormat conditionWhenValueIsNotEqual(Style apply, String value) {
        return new ConditionalFormat(apply, "cell-content()!=\"" + value + "\"");
    }

    public static ConditionalFormat conditionWhenTextContains(Style apply, String text) {
        return new ConditionalFormat(apply, "contains(cell-content(),\"" + text + "\")");
    }

    public static ConditionalFormat conditionWhenTextDoesNotContain(Style apply, String text) {
        return new ConditionalFormat(apply, "not(contains(cell-content(),\"" + text + "\"))");
    }

    public static ConditionalFormat conditionWhenTextStartsWith(Style apply, String text) {
        return new ConditionalFormat(apply, "starts-with(cell-content(),\"" + text + "\")");
    }

    public static ConditionalFormat conditionWhenTextEndsWith(Style apply, String text) {
        return new ConditionalFormat(apply, "ends-with(cell-content(),\"" + text + "\")");
    }

    public static ConditionalFormat conditionWhenCellIsEmpty(Style apply) {
        return new ConditionalFormat(apply, "cell-content()=\"\"");
    }

    public static ConditionalFormat conditionWhenCellIsNotEmpty(Style apply) {
        return new ConditionalFormat(apply, "cell-content()!=\"\"");
    }

    public static ConditionalFormat conditionWhenValueIsBetween(Style apply, double init, double end) {
        if (init >= end) {
            throw new IllegalArgumentException("Value init " + init + " is greater than end " + end + " argument");
        }
        return new ConditionalFormat(apply, "cell-content-is-between(" + init + "," + end + ")");
    }
}

