/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnostics;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnosticsConfiguration;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.Diagnostics;

public class ResidualTradingDaysDiagnosticsFactory<R extends Explorable>
implements SaDiagnosticsFactory<ResidualTradingDaysDiagnosticsConfiguration, R> {
    public static final String NAME = "Residual trading days tests";
    public static final String DESC = "Residual trading days tests";
    static final String FTEST_SA = "F-Test on SA (td)";
    static final String FTEST_I = "F-Test on I (td)";
    static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("F-Test on SA (td)", "F-Test on I (td)"));
    private final ResidualTradingDaysDiagnosticsConfiguration config;
    private final Function<R, ResidualTradingDaysDiagnostics.Input> extractor;

    public ResidualTradingDaysDiagnosticsFactory(ResidualTradingDaysDiagnosticsConfiguration config, Function<R, ResidualTradingDaysDiagnostics.Input> extractor) {
        this.config = config;
        this.extractor = extractor;
    }

    public ResidualTradingDaysDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public ResidualTradingDaysDiagnosticsFactory<R> with(ResidualTradingDaysDiagnosticsConfiguration config) {
        return new ResidualTradingDaysDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return "Residual trading days tests";
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return ResidualTradingDaysDiagnostics.of(this.config, this.extractor.apply(rslts));
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.Final;
    }

    public int getOrder() {
        return 100;
    }
}

