/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import java.util.Iterator;
import jdplus.toolkit.base.core.data.DataBlock;

public class DataBlockIterator
implements Iterator<DataBlock> {
    private final DataBlock data;
    private final int end;
    private final int inc;
    private int pos;

    protected DataBlockIterator(DataBlock start, int niter, int inc) {
        this.data = start;
        this.end = niter;
        this.inc = inc;
        this.pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.end;
    }

    @Override
    public DataBlock next() {
        ++this.pos;
        this.data.slide(this.inc);
        return this.data;
    }

    public void begin() {
        this.reset(0);
    }

    public void reset(int newpos) {
        int del = this.pos - newpos;
        if (del != 0) {
            this.data.slide(-(del *= this.inc));
            this.pos = newpos;
        }
    }

    public void reset() {
        this.reset(0);
    }
}

