/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiltering;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class Filtering
implements IFiltering {
    private final IFiniteFilter cf;
    private final IFiniteFilter[] lf;
    private final IFiniteFilter[] rf;

    public Filtering(IFiniteFilter cf, IFiniteFilter[] lf, IFiniteFilter[] rf) {
        this.cf = cf;
        this.lf = (IFiniteFilter[])lf.clone();
        this.rf = (IFiniteFilter[])rf.clone();
    }

    public static Filtering of(DoubleSeq cf, Matrix lf, Matrix rf) {
        int lb = lf.getColumnsCount();
        int rb = rf.getColumnsCount();
        if (cf.length() != lb + rb + 1) {
            throw new IllegalArgumentException();
        }
        FiniteFilter fcf = new FiniteFilter(Polynomial.of(cf.toArray()), -lb);
        IFiniteFilter[] flf = new IFiniteFilter[lb];
        for (int i = 0; i < lb; ++i) {
            double[] p = lf.column(i).drop(0, i).toArray();
            FiniteFilter f = FiniteFilter.of(p, i + 1 - lb);
            flf[i] = f;
        }
        IFiniteFilter[] frf = new IFiniteFilter[rb];
        int nr = rf.getRowsCount() - rb;
        for (int i = 0; i < rb; ++i) {
            double[] p = rf.column(i).drop(0, i).toArray();
            FiniteFilter f = FiniteFilter.of(p, -nr);
            frf[i] = f;
            flf[i] = f.mirror();
        }
        return new Filtering(fcf, flf, frf);
    }

    public static Filtering of(DoubleSeq cf, Matrix rf) {
        int nlags = rf.getColumnsCount();
        if (cf.length() != 2 * nlags + 1) {
            throw new IllegalArgumentException();
        }
        FiniteFilter fcf = new FiniteFilter(Polynomial.of(cf.toArray()), -nlags);
        IFiniteFilter[] flf = new IFiniteFilter[nlags];
        IFiniteFilter[] frf = new IFiniteFilter[nlags];
        for (int i = 0; i < nlags; ++i) {
            double[] p = rf.column(i).drop(0, i).toArray();
            FiniteFilter f = FiniteFilter.of(p, -nlags);
            frf[i] = f;
            flf[i] = f.mirror();
        }
        return new Filtering(fcf, flf, frf);
    }

    public static IFiniteFilter[] leftFilters(Matrix lf) {
        int nlags = lf.getColumnsCount();
        IFiniteFilter[] flf = new IFiniteFilter[nlags];
        for (int i = 0; i < nlags; ++i) {
            double[] p = lf.column(i).drop(0, i).toArray();
            FiniteFilter f = FiniteFilter.of(p, i + 1 - nlags);
            flf[i] = f;
        }
        return flf;
    }

    public static IFiniteFilter[] rightFilters(Matrix rf) {
        int nlags = rf.getColumnsCount();
        IFiniteFilter[] frf = new IFiniteFilter[nlags];
        for (int i = 0; i < nlags; ++i) {
            double[] p = rf.column(i).drop(0, i).toArray();
            FiniteFilter f = FiniteFilter.of(p, -nlags);
            frf[i] = f;
        }
        return frf;
    }

    @Override
    public IFiniteFilter centralFilter() {
        return this.cf;
    }

    @Override
    public IFiniteFilter[] leftEndPointsFilters() {
        return (IFiniteFilter[])this.lf.clone();
    }

    @Override
    public IFiniteFilter[] rightEndPointsFilters() {
        return (IFiniteFilter[])this.rf.clone();
    }
}

