/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;
import lombok.Generated;

public final class Gauss {
    public static LUDecomposition decompose(FastMatrix M) {
        return Gauss.decompose(M, Constants.getEpsilon());
    }

    public static LUDecomposition decompose(FastMatrix M, double eps) {
        int n = M.getColumnsCount();
        if (M.getRowsCount() != n) {
            throw new MatrixException("m_err_square");
        }
        double[] lu = M.toArray();
        int[] piv = null;
        int k = 0;
        int kn = 0;
        while (k < n) {
            double kk;
            int i;
            int p = k;
            double pmax = Math.abs(lu[kn + k]);
            for (i = k + 1; i < n; ++i) {
                double cur = Math.abs(lu[kn + i]);
                if (!(cur > pmax)) continue;
                p = i;
                pmax = cur;
            }
            if (p != k) {
                if (piv == null) {
                    piv = new int[n];
                    for (i = 0; i < n; ++i) {
                        piv[i] = i;
                    }
                }
                int j = 0;
                int pj = p;
                int kj = k;
                while (j < n) {
                    double tmp = lu[pj];
                    lu[pj] = lu[kj];
                    lu[kj] = tmp;
                    ++j;
                    pj += n;
                    kj += n;
                }
                int t = piv[p];
                piv[p] = piv[k];
                piv[k] = t;
            }
            if ((kk = lu[kn + k]) == 0.0) {
                throw new MatrixException("m_err_sing");
            }
            for (int i2 = k + 1; i2 < n; ++i2) {
                int n2 = i2 + kn;
                double d = lu[n2] / kk;
                lu[n2] = d;
                double alpha = d;
                int j = k + 1;
                int jn = j * n;
                while (j < n) {
                    int n3 = i2 + jn;
                    lu[n3] = lu[n3] - alpha * lu[k + jn];
                    ++j;
                    jn += n;
                }
            }
            ++k;
            kn += n;
        }
        return new LUDecomposition(FastMatrix.builder(lu).nrows(n).ncolumns(n).build(), piv);
    }

    @Generated
    private Gauss() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

