/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public class LDLDecomposition {
    private FastMatrix M;

    public void decompose(FastMatrix S, double zero) {
        this.M = S.deepClone();
        double[] data = this.M.getStorage();
        int n = this.M.getRowsCount();
        int cinc = this.M.getColumnIncrement();
        int dinc = 1 + cinc;
        int start = this.M.getStartPosition();
        int end = start + n * dinc;
        int idiag = start;
        int irow = start;
        int cend = start + n;
        while (idiag != end) {
            double aii = data[idiag];
            int j = irow;
            int k = start;
            while (j != idiag) {
                double x = data[j];
                if (data[k] != 0.0) {
                    aii -= x * x * data[k];
                }
                j += cinc;
                k += dinc;
            }
            if (aii >= -zero && aii <= zero) {
                data[idiag] = 0.0;
                jx = irow;
                k = start;
                while (jx != idiag) {
                    temp = data[jx] * data[k];
                    if (temp != 0.0) {
                        ia = jx + 1;
                        iy = idiag + 1;
                        while (iy < cend) {
                            int n2 = iy++;
                            data[n2] = data[n2] - temp * data[ia];
                            ++ia;
                        }
                    }
                    jx += cinc;
                    k += dinc;
                }
                for (iy = idiag + 1; iy < cend; ++iy) {
                    if (Math.abs(data[iy]) > zero) {
                        throw new MatrixException("err_ldl");
                    }
                    data[iy] = 0.0;
                }
            } else {
                data[idiag] = aii;
                jx = irow;
                k = start;
                while (jx != idiag) {
                    temp = data[jx] * data[k];
                    if (temp != 0.0) {
                        ia = jx + 1;
                        iy = idiag + 1;
                        while (iy < cend) {
                            int n3 = iy++;
                            data[n3] = data[n3] - temp * data[ia];
                            ++ia;
                        }
                    }
                    jx += cinc;
                    k += dinc;
                }
                iy = idiag + 1;
                while (iy < cend) {
                    int n4 = iy++;
                    data[n4] = data[n4] / aii;
                }
            }
            ++irow;
            idiag += dinc;
            cend += cinc;
        }
        LowerTriangularMatrix.toLower(this.M);
    }

    public FastMatrix L() {
        FastMatrix L = this.M.deepClone();
        L.diagonal().set(1.0);
        return L;
    }

    public FastMatrix D() {
        return FastMatrix.diagonal((DoubleSeq)this.M.diagonal());
    }

    public DoubleSeq diagonal() {
        return this.M.diagonal().unmodifiable();
    }
}

