/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.Arithmetics;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;

public class UnitRootsSolver {
    private Polynomial remainder;
    private UnitRoots roots;
    private int startDegree = 0;
    private static final double EPS = 1.0E-9;

    private static double pnorm(Polynomial p, int n) {
        switch (n) {
            case 1: {
                double x = p.evaluateAt(1.0);
                return Math.abs(x);
            }
            case 2: {
                double x = p.evaluateAt(-1.0);
                return Math.abs(x);
            }
        }
        double x = Math.PI * 2 / (double)n;
        Complex c = Complex.cart((double)Math.cos(x), (double)Math.sin(x));
        Complex val = p.evaluateAt(c);
        return val.abs();
    }

    public UnitRootsSolver() {
    }

    public UnitRootsSolver(int start) {
        if (start != 0) {
            this.startDegree = start;
        }
    }

    public boolean factorize(Polynomial p) {
        this.roots = new UnitRoots();
        this.remainder = this.process(p, this.roots);
        return this.roots.getRootsCount() != 0;
    }

    public UnitRoots getUnitRoots() {
        return this.roots;
    }

    private Polynomial process(Polynomial p, UnitRoots ur) {
        int num = this.startDegree == 0 ? p.degree() * 2 + 1 : this.startDegree;
        int[] divs = new int[num];
        UnitRoots tmp = new UnitRoots();
        Polynomial cur = p;
        while (num >= 1) {
            if (UnitRootsSolver.pnorm(cur, num) < 1.0E-9) {
                tmp.add(num);
                int ndiv = Arithmetics.divisors(num, divs);
                for (int cdiv = ndiv - 1; cdiv >= 0; --cdiv) {
                    if (!(UnitRootsSolver.pnorm(cur, divs[cdiv]) > 1.0E-9)) continue;
                    tmp.removeOnly(divs, cdiv);
                }
                Polynomial q = UnitRoots.divide(cur, tmp);
                if (q != null) {
                    cur = q;
                    ur.add(tmp);
                } else {
                    --num;
                }
                tmp.clear();
                continue;
            }
            --num;
        }
        return cur;
    }

    public Polynomial remainder() {
        return this.remainder;
    }

    public Complex[] roots() {
        return this.roots == null ? null : this.roots.roots();
    }
}

